/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import java.util.ArrayList;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcProviderConfigurationEndpointFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OidcConfigurer
extends AbstractOAuth2Configurer {
    private OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer;
    private RequestMatcher requestMatcher;

    OidcConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OidcConfigurer clientRegistrationEndpoint(Customizer<OidcClientRegistrationEndpointConfigurer> clientRegistrationEndpointCustomizer) {
        if (this.clientRegistrationEndpointConfigurer == null) {
            this.clientRegistrationEndpointConfigurer = new OidcClientRegistrationEndpointConfigurer(this.getObjectPostProcessor());
        }
        clientRegistrationEndpointCustomizer.customize((Object)this.clientRegistrationEndpointConfigurer);
        return this;
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void init(B builder) {
        if (this.clientRegistrationEndpointConfigurer != null) {
            this.clientRegistrationEndpointConfigurer.init(builder);
        }
        ArrayList<Object> requestMatchers = new ArrayList<Object>();
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        if (providerSettings.getIssuer() != null) {
            requestMatchers.add(new AntPathRequestMatcher("/.well-known/openid-configuration", HttpMethod.GET.name()));
        }
        if (this.clientRegistrationEndpointConfigurer != null) {
            requestMatchers.add(this.clientRegistrationEndpointConfigurer.getRequestMatcher());
        }
        this.requestMatcher = !requestMatchers.isEmpty() ? new OrRequestMatcher(requestMatchers) : request -> false;
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void configure(B builder) {
        ProviderSettings providerSettings;
        if (this.clientRegistrationEndpointConfigurer != null) {
            this.clientRegistrationEndpointConfigurer.configure(builder);
        }
        if ((providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder)).getIssuer() != null) {
            OidcProviderConfigurationEndpointFilter oidcProviderConfigurationEndpointFilter = new OidcProviderConfigurationEndpointFilter(providerSettings);
            builder.addFilterBefore((Filter)this.postProcess(oidcProviderConfigurationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }
}

