/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.security.Principal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.core.authentication.OAuth2AuthenticationValidator;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationCodeRequestAuthenticationProvider
implements AuthenticationProvider {
    private static final OAuth2TokenType STATE_TOKEN_TYPE = new OAuth2TokenType("state");
    private static final String PKCE_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc7636#section-4.4.1";
    private static final StringKeyGenerator DEFAULT_AUTHORIZATION_CODE_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);
    private static final StringKeyGenerator DEFAULT_STATE_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private static final Function<String, OAuth2AuthenticationValidator> DEFAULT_AUTHENTICATION_VALIDATOR_RESOLVER = OAuth2AuthorizationCodeRequestAuthenticationProvider.createDefaultAuthenticationValidatorResolver();
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2AuthorizationConsentService authorizationConsentService;
    private Supplier<String> authorizationCodeGenerator = () -> ((StringKeyGenerator)DEFAULT_AUTHORIZATION_CODE_GENERATOR).generateKey();
    private Function<String, OAuth2AuthenticationValidator> authenticationValidatorResolver = DEFAULT_AUTHENTICATION_VALIDATOR_RESOLVER;

    public OAuth2AuthorizationCodeRequestAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.authorizationConsentService = authorizationConsentService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        return authorizationCodeRequestAuthentication.isConsent() ? this.authenticateAuthorizationConsent(authentication) : this.authenticateAuthorizationRequest(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2AuthorizationCodeRequestAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthorizationCodeGenerator(Supplier<String> authorizationCodeGenerator) {
        Assert.notNull(authorizationCodeGenerator, (String)"authorizationCodeGenerator cannot be null");
        this.authorizationCodeGenerator = authorizationCodeGenerator;
    }

    public void setAuthenticationValidatorResolver(Function<String, OAuth2AuthenticationValidator> authenticationValidatorResolver) {
        Assert.notNull(authenticationValidatorResolver, (String)"authenticationValidatorResolver cannot be null");
        this.authenticationValidatorResolver = authenticationValidatorResolver;
    }

    private Authentication authenticateAuthorizationRequest(Authentication authentication) throws AuthenticationException {
        OAuth2AuthorizationConsent currentAuthorizationConsent;
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(authorizationCodeRequestAuthentication.getClientId());
        if (registeredClient == null) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "client_id", authorizationCodeRequestAuthentication, null);
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put(RegisteredClient.class, registeredClient);
        OAuth2AuthenticationContext authenticationContext = new OAuth2AuthenticationContext((Authentication)authorizationCodeRequestAuthentication, context);
        OAuth2AuthenticationValidator redirectUriValidator = this.resolveAuthenticationValidator("redirect_uri");
        redirectUriValidator.validate(authenticationContext);
        if (!registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("unauthorized_client", "client_id", authorizationCodeRequestAuthentication, registeredClient);
        }
        OAuth2AuthenticationValidator scopeValidator = this.resolveAuthenticationValidator("scope");
        scopeValidator.validate(authenticationContext);
        String codeChallenge = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("code_challenge");
        if (StringUtils.hasText((String)codeChallenge)) {
            String codeChallengeMethod = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("code_challenge_method");
            if (StringUtils.hasText((String)codeChallengeMethod) && !"S256".equals(codeChallengeMethod) && !"plain".equals(codeChallengeMethod)) {
                OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "code_challenge_method", PKCE_ERROR_URI, authorizationCodeRequestAuthentication, registeredClient, null);
            }
        } else if (registeredClient.getClientSettings().isRequireProofKey()) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "code_challenge", PKCE_ERROR_URI, authorizationCodeRequestAuthentication, registeredClient, null);
        }
        Authentication principal = (Authentication)authorizationCodeRequestAuthentication.getPrincipal();
        if (!OAuth2AuthorizationCodeRequestAuthenticationProvider.isPrincipalAuthenticated(principal)) {
            return authorizationCodeRequestAuthentication;
        }
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(authorizationCodeRequestAuthentication.getAuthorizationUri()).clientId(registeredClient.getClientId()).redirectUri(authorizationCodeRequestAuthentication.getRedirectUri()).scopes(authorizationCodeRequestAuthentication.getScopes()).state(authorizationCodeRequestAuthentication.getState()).additionalParameters(authorizationCodeRequestAuthentication.getAdditionalParameters()).build();
        if (OAuth2AuthorizationCodeRequestAuthenticationProvider.requireAuthorizationConsent(registeredClient, authorizationRequest, currentAuthorizationConsent = this.authorizationConsentService.findById(registeredClient.getId(), principal.getName()))) {
            String state = DEFAULT_STATE_GENERATOR.generateKey();
            OAuth2Authorization authorization = OAuth2AuthorizationCodeRequestAuthenticationProvider.authorizationBuilder(registeredClient, principal, authorizationRequest).attribute("state", state).build();
            this.authorizationService.save(authorization);
            Set<String> currentAuthorizedScopes = currentAuthorizationConsent != null ? currentAuthorizationConsent.getScopes() : null;
            return OAuth2AuthorizationCodeRequestAuthenticationToken.with(registeredClient.getClientId(), principal).authorizationUri(authorizationRequest.getAuthorizationUri()).scopes(currentAuthorizedScopes).state(state).consentRequired(true).build();
        }
        OAuth2AuthorizationCode authorizationCode = this.generateAuthorizationCode();
        OAuth2Authorization authorization = OAuth2AuthorizationCodeRequestAuthenticationProvider.authorizationBuilder(registeredClient, principal, authorizationRequest).token(authorizationCode).attribute(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizationRequest.getScopes()).build();
        this.authorizationService.save(authorization);
        String redirectUri = authorizationRequest.getRedirectUri();
        if (!StringUtils.hasText((String)redirectUri)) {
            redirectUri = registeredClient.getRedirectUris().iterator().next();
        }
        return OAuth2AuthorizationCodeRequestAuthenticationToken.with(registeredClient.getClientId(), principal).authorizationUri(authorizationRequest.getAuthorizationUri()).redirectUri(redirectUri).scopes(authorizationRequest.getScopes()).state(authorizationRequest.getState()).authorizationCode(authorizationCode).build();
    }

    private OAuth2AuthenticationValidator resolveAuthenticationValidator(String parameterName) {
        OAuth2AuthenticationValidator authenticationValidator = this.authenticationValidatorResolver.apply(parameterName);
        return authenticationValidator != null ? authenticationValidator : DEFAULT_AUTHENTICATION_VALIDATOR_RESOLVER.apply(parameterName);
    }

    private OAuth2AuthorizationCode generateAuthorizationCode() {
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(5L, ChronoUnit.MINUTES);
        return new OAuth2AuthorizationCode(this.authorizationCodeGenerator.get(), issuedAt, expiresAt);
    }

    private Authentication authenticateAuthorizationConsent(Authentication authentication) throws AuthenticationException {
        OAuth2AuthorizationConsent currentAuthorizationConsent;
        Set<Object> currentAuthorizedScopes;
        HashSet<String> authorizedScopes;
        OAuth2AuthorizationRequest authorizationRequest;
        Set requestedScopes;
        RegisteredClient registeredClient;
        Authentication principal;
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        OAuth2Authorization authorization = this.authorizationService.findByToken(authorizationCodeRequestAuthentication.getState(), STATE_TOKEN_TYPE);
        if (authorization == null) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "state", authorizationCodeRequestAuthentication, null, null);
        }
        if (!OAuth2AuthorizationCodeRequestAuthenticationProvider.isPrincipalAuthenticated(principal = (Authentication)authorizationCodeRequestAuthentication.getPrincipal()) || !principal.getName().equals(authorization.getPrincipalName())) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "state", authorizationCodeRequestAuthentication, null, null);
        }
        if ((registeredClient = this.registeredClientRepository.findByClientId(authorizationCodeRequestAuthentication.getClientId())) == null || !registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "client_id", authorizationCodeRequestAuthentication, registeredClient);
        }
        if (!(requestedScopes = (authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName())).getScopes()).containsAll(authorizedScopes = new HashSet<String>(authorizationCodeRequestAuthentication.getScopes()))) {
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_scope", "scope", authorizationCodeRequestAuthentication, registeredClient, authorizationRequest);
        }
        Set<Object> set = currentAuthorizedScopes = (currentAuthorizationConsent = this.authorizationConsentService.findById(authorization.getRegisteredClientId(), authorization.getPrincipalName())) != null ? currentAuthorizationConsent.getScopes() : Collections.emptySet();
        if (authorizedScopes.isEmpty() && currentAuthorizedScopes.isEmpty()) {
            this.authorizationService.remove(authorization);
            OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("access_denied", "client_id", authorizationCodeRequestAuthentication, registeredClient, authorizationRequest);
        }
        if (requestedScopes.contains("openid")) {
            authorizedScopes.add("openid");
        }
        if (!currentAuthorizedScopes.isEmpty()) {
            for (String requestedScope : requestedScopes) {
                if (!currentAuthorizedScopes.contains(requestedScope)) continue;
                authorizedScopes.add(requestedScope);
            }
        }
        if (!authorizedScopes.isEmpty() && !authorizedScopes.equals(currentAuthorizedScopes)) {
            OAuth2AuthorizationConsent.Builder authorizationConsentBuilder = currentAuthorizationConsent != null ? OAuth2AuthorizationConsent.from(currentAuthorizationConsent) : OAuth2AuthorizationConsent.withId(authorization.getRegisteredClientId(), authorization.getPrincipalName());
            authorizedScopes.forEach(authorizationConsentBuilder::scope);
            OAuth2AuthorizationConsent authorizationConsent = authorizationConsentBuilder.build();
            this.authorizationConsentService.save(authorizationConsent);
        }
        OAuth2AuthorizationCode authorizationCode = this.generateAuthorizationCode();
        OAuth2Authorization updatedAuthorization = OAuth2Authorization.from(authorization).token(authorizationCode).attributes(attrs -> {
            attrs.remove("state");
            attrs.put(OAuth2Authorization.AUTHORIZED_SCOPE_ATTRIBUTE_NAME, authorizedScopes);
        }).build();
        this.authorizationService.save(updatedAuthorization);
        String redirectUri = authorizationRequest.getRedirectUri();
        if (!StringUtils.hasText((String)redirectUri)) {
            redirectUri = registeredClient.getRedirectUris().iterator().next();
        }
        return OAuth2AuthorizationCodeRequestAuthenticationToken.with(registeredClient.getClientId(), principal).authorizationUri(authorizationRequest.getAuthorizationUri()).redirectUri(redirectUri).scopes(authorizedScopes).state(authorizationRequest.getState()).authorizationCode(authorizationCode).build();
    }

    private static Function<String, OAuth2AuthenticationValidator> createDefaultAuthenticationValidatorResolver() {
        HashMap<String, OAuth2AuthenticationValidator> authenticationValidators = new HashMap<String, OAuth2AuthenticationValidator>();
        authenticationValidators.put("redirect_uri", new DefaultRedirectUriOAuth2AuthenticationValidator());
        authenticationValidators.put("scope", new DefaultScopeOAuth2AuthenticationValidator());
        return authenticationValidators::get;
    }

    private static OAuth2Authorization.Builder authorizationBuilder(RegisteredClient registeredClient, Authentication principal, OAuth2AuthorizationRequest authorizationRequest) {
        return OAuth2Authorization.withRegisteredClient(registeredClient).principalName(principal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(Principal.class.getName(), principal).attribute(OAuth2AuthorizationRequest.class.getName(), authorizationRequest);
    }

    private static boolean requireAuthorizationConsent(RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest, OAuth2AuthorizationConsent authorizationConsent) {
        if (!registeredClient.getClientSettings().isRequireAuthorizationConsent()) {
            return false;
        }
        if (authorizationRequest.getScopes().contains("openid") && authorizationRequest.getScopes().size() == 1) {
            return false;
        }
        return authorizationConsent == null || !authorizationConsent.getScopes().containsAll(authorizationRequest.getScopes());
    }

    private static boolean isValidRedirectUri(String requestedRedirectUri, RegisteredClient registeredClient) {
        UriComponents requestedRedirect;
        try {
            requestedRedirect = UriComponentsBuilder.fromUriString((String)requestedRedirectUri).build();
            if (requestedRedirect.getFragment() != null) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        String requestedRedirectHost = requestedRedirect.getHost();
        if (requestedRedirectHost == null || requestedRedirectHost.equals("localhost")) {
            return false;
        }
        if (!OAuth2AuthorizationCodeRequestAuthenticationProvider.isLoopbackAddress(requestedRedirectHost)) {
            return registeredClient.getRedirectUris().contains(requestedRedirectUri);
        }
        for (String registeredRedirectUri : registeredClient.getRedirectUris()) {
            UriComponentsBuilder registeredRedirect = UriComponentsBuilder.fromUriString((String)registeredRedirectUri);
            registeredRedirect.port(requestedRedirect.getPort());
            if (!registeredRedirect.build().toString().equals(requestedRedirect.toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLoopbackAddress(String host) {
        if ("[0:0:0:0:0:0:0:1]".equals(host) || "[::1]".equals(host)) {
            return true;
        }
        String[] ipv4Octets = host.split("\\.");
        if (ipv4Octets.length != 4) {
            return false;
        }
        try {
            int[] address = new int[ipv4Octets.length];
            for (int i = 0; i < ipv4Octets.length; ++i) {
                address[i] = Integer.parseInt(ipv4Octets[i]);
            }
            return address[0] == 127 && address[1] >= 0 && address[1] <= 255 && address[2] >= 0 && address[2] <= 255 && address[3] >= 1 && address[3] <= 255;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null && !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) && principal.isAuthenticated();
    }

    private static void throwError(String errorCode, String parameterName, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient) {
        OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError(errorCode, parameterName, authorizationCodeRequestAuthentication, registeredClient, null);
    }

    private static void throwError(String errorCode, String parameterName, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError(errorCode, parameterName, "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1", authorizationCodeRequestAuthentication, registeredClient, authorizationRequest);
    }

    private static void throwError(String errorCode, String parameterName, String errorUri, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        boolean redirectOnError = true;
        if (errorCode.equals("invalid_request") && (parameterName.equals("client_id") || parameterName.equals("redirect_uri") || parameterName.equals("state"))) {
            redirectOnError = false;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthenticationResult = authorizationCodeRequestAuthentication;
        if (redirectOnError && !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            String redirectUri = OAuth2AuthorizationCodeRequestAuthenticationProvider.resolveRedirectUri(authorizationRequest, registeredClient);
            String state = authorizationCodeRequestAuthentication.isConsent() && authorizationRequest != null ? authorizationRequest.getState() : authorizationCodeRequestAuthentication.getState();
            authorizationCodeRequestAuthenticationResult = OAuth2AuthorizationCodeRequestAuthenticationProvider.from(authorizationCodeRequestAuthentication).redirectUri(redirectUri).state(state).build();
            authorizationCodeRequestAuthenticationResult.setAuthenticated(authorizationCodeRequestAuthentication.isAuthenticated());
        } else if (!redirectOnError && StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            authorizationCodeRequestAuthenticationResult = OAuth2AuthorizationCodeRequestAuthenticationProvider.from(authorizationCodeRequestAuthentication).redirectUri(null).build();
            authorizationCodeRequestAuthenticationResult.setAuthenticated(authorizationCodeRequestAuthentication.isAuthenticated());
        }
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthenticationResult);
    }

    private static String resolveRedirectUri(OAuth2AuthorizationRequest authorizationRequest, RegisteredClient registeredClient) {
        if (authorizationRequest != null && StringUtils.hasText((String)authorizationRequest.getRedirectUri())) {
            return authorizationRequest.getRedirectUri();
        }
        if (registeredClient != null) {
            return registeredClient.getRedirectUris().iterator().next();
        }
        return null;
    }

    private static OAuth2AuthorizationCodeRequestAuthenticationToken.Builder from(OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication) {
        return OAuth2AuthorizationCodeRequestAuthenticationToken.with(authorizationCodeRequestAuthentication.getClientId(), (Authentication)authorizationCodeRequestAuthentication.getPrincipal()).authorizationUri(authorizationCodeRequestAuthentication.getAuthorizationUri()).redirectUri(authorizationCodeRequestAuthentication.getRedirectUri()).scopes(authorizationCodeRequestAuthentication.getScopes()).state(authorizationCodeRequestAuthentication.getState()).additionalParameters(authorizationCodeRequestAuthentication.getAdditionalParameters()).consentRequired(authorizationCodeRequestAuthentication.isConsentRequired()).consent(authorizationCodeRequestAuthentication.isConsent()).authorizationCode(authorizationCodeRequestAuthentication.getAuthorizationCode());
    }

    private static class DefaultScopeOAuth2AuthenticationValidator
    implements OAuth2AuthenticationValidator {
        private DefaultScopeOAuth2AuthenticationValidator() {
        }

        @Override
        public void validate(OAuth2AuthenticationContext authenticationContext) {
            OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)((Object)authenticationContext.getAuthentication());
            RegisteredClient registeredClient = authenticationContext.get(RegisteredClient.class);
            Set<String> requestedScopes = authorizationCodeRequestAuthentication.getScopes();
            Set<String> allowedScopes = registeredClient.getScopes();
            if (!requestedScopes.isEmpty() && !allowedScopes.containsAll(requestedScopes)) {
                OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_scope", "scope", authorizationCodeRequestAuthentication, registeredClient);
            }
        }
    }

    private static class DefaultRedirectUriOAuth2AuthenticationValidator
    implements OAuth2AuthenticationValidator {
        private DefaultRedirectUriOAuth2AuthenticationValidator() {
        }

        @Override
        public void validate(OAuth2AuthenticationContext authenticationContext) {
            OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)((Object)authenticationContext.getAuthentication());
            RegisteredClient registeredClient = authenticationContext.get(RegisteredClient.class);
            if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
                if (!OAuth2AuthorizationCodeRequestAuthenticationProvider.isValidRedirectUri(authorizationCodeRequestAuthentication.getRedirectUri(), registeredClient)) {
                    OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "redirect_uri", authorizationCodeRequestAuthentication, registeredClient);
                }
            } else if (authorizationCodeRequestAuthentication.getScopes().contains("openid") || registeredClient.getRedirectUris().size() != 1) {
                OAuth2AuthorizationCodeRequestAuthenticationProvider.throwError("invalid_request", "redirect_uri", authorizationCodeRequestAuthentication, registeredClient);
            }
        }
    }
}

