/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.util.Map;
import org.springframework.security.oauth2.server.authorization.config.AbstractSettings;
import org.springframework.security.oauth2.server.authorization.config.ConfigurationSettingNames;
import org.springframework.util.Assert;

public final class ClientSettings
extends AbstractSettings {
    private ClientSettings(Map<String, Object> settings) {
        super(settings);
    }

    public boolean isRequireProofKey() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.Client.REQUIRE_PROOF_KEY);
    }

    public boolean isRequireAuthorizationConsent() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.Client.REQUIRE_AUTHORIZATION_CONSENT);
    }

    public static Builder builder() {
        return new Builder().requireProofKey(false).requireAuthorizationConsent(false);
    }

    public static Builder withSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        return (Builder)new Builder().settings(s -> s.putAll(settings));
    }

    public static class Builder
    extends AbstractSettings.AbstractBuilder<ClientSettings, Builder> {
        private Builder() {
        }

        public Builder requireProofKey(boolean requireProofKey) {
            return (Builder)this.setting(ConfigurationSettingNames.Client.REQUIRE_PROOF_KEY, requireProofKey);
        }

        public Builder requireAuthorizationConsent(boolean requireAuthorizationConsent) {
            return (Builder)this.setting(ConfigurationSettingNames.Client.REQUIRE_AUTHORIZATION_CONSENT, requireAuthorizationConsent);
        }

        @Override
        public ClientSettings build() {
            return new ClientSettings(this.getSettings());
        }
    }
}

