/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config;

import java.time.Duration;
import java.util.Map;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.config.AbstractSettings;
import org.springframework.security.oauth2.server.authorization.config.ConfigurationSettingNames;
import org.springframework.util.Assert;

public final class TokenSettings
extends AbstractSettings {
    private TokenSettings(Map<String, Object> settings) {
        super(settings);
    }

    public Duration getAccessTokenTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.ACCESS_TOKEN_TIME_TO_LIVE);
    }

    public boolean isReuseRefreshTokens() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.Token.REUSE_REFRESH_TOKENS);
    }

    public Duration getRefreshTokenTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.REFRESH_TOKEN_TIME_TO_LIVE);
    }

    public SignatureAlgorithm getIdTokenSignatureAlgorithm() {
        return (SignatureAlgorithm)this.getSetting(ConfigurationSettingNames.Token.ID_TOKEN_SIGNATURE_ALGORITHM);
    }

    public static Builder builder() {
        return new Builder().accessTokenTimeToLive(Duration.ofMinutes(5L)).reuseRefreshTokens(true).refreshTokenTimeToLive(Duration.ofMinutes(60L)).idTokenSignatureAlgorithm(SignatureAlgorithm.RS256);
    }

    public static Builder withSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        return (Builder)new Builder().settings(s -> s.putAll(settings));
    }

    public static class Builder
    extends AbstractSettings.AbstractBuilder<TokenSettings, Builder> {
        private Builder() {
        }

        public Builder accessTokenTimeToLive(Duration accessTokenTimeToLive) {
            Assert.notNull((Object)accessTokenTimeToLive, (String)"accessTokenTimeToLive cannot be null");
            Assert.isTrue((accessTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"accessTokenTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.ACCESS_TOKEN_TIME_TO_LIVE, accessTokenTimeToLive);
        }

        public Builder reuseRefreshTokens(boolean reuseRefreshTokens) {
            return (Builder)this.setting(ConfigurationSettingNames.Token.REUSE_REFRESH_TOKENS, reuseRefreshTokens);
        }

        public Builder refreshTokenTimeToLive(Duration refreshTokenTimeToLive) {
            Assert.notNull((Object)refreshTokenTimeToLive, (String)"refreshTokenTimeToLive cannot be null");
            Assert.isTrue((refreshTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"refreshTokenTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.REFRESH_TOKEN_TIME_TO_LIVE, refreshTokenTimeToLive);
        }

        public Builder idTokenSignatureAlgorithm(SignatureAlgorithm idTokenSignatureAlgorithm) {
            Assert.notNull((Object)idTokenSignatureAlgorithm, (String)"idTokenSignatureAlgorithm cannot be null");
            return (Builder)this.setting(ConfigurationSettingNames.Token.ID_TOKEN_SIGNATURE_ALGORITHM, idTokenSignatureAlgorithm);
        }

        @Override
        public TokenSettings build() {
            return new TokenSettings(this.getSettings());
        }
    }
}

