/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.Assert;

public final class OAuth2ErrorAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private HttpMessageConverter<OAuth2Error> errorResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
        if (authenticationException instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oauth2AuthenticationException = (OAuth2AuthenticationException)authenticationException;
            OAuth2Error error = oauth2AuthenticationException.getError();
            this.errorResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(AuthenticationException.class.getSimpleName() + " must be of type " + OAuth2AuthenticationException.class.getName() + " but was " + authenticationException.getClass().getName()));
        }
    }

    public void setErrorResponseConverter(HttpMessageConverter<OAuth2Error> errorResponseConverter) {
        Assert.notNull(errorResponseConverter, (String)"errorResponseConverter cannot be null");
        this.errorResponseConverter = errorResponseConverter;
    }
}

