/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.settings;

import java.time.Duration;
import java.util.Map;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.settings.AbstractSettings;
import org.springframework.security.oauth2.server.authorization.settings.ConfigurationSettingNames;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.util.Assert;

public final class TokenSettings
extends AbstractSettings {
    private TokenSettings(Map<String, Object> settings) {
        super(settings);
    }

    public Duration getAuthorizationCodeTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.AUTHORIZATION_CODE_TIME_TO_LIVE);
    }

    public Duration getAccessTokenTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.ACCESS_TOKEN_TIME_TO_LIVE);
    }

    public OAuth2TokenFormat getAccessTokenFormat() {
        return (OAuth2TokenFormat)this.getSetting(ConfigurationSettingNames.Token.ACCESS_TOKEN_FORMAT);
    }

    public Duration getDeviceCodeTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.DEVICE_CODE_TIME_TO_LIVE);
    }

    public boolean isReuseRefreshTokens() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.Token.REUSE_REFRESH_TOKENS);
    }

    public Duration getRefreshTokenTimeToLive() {
        return (Duration)this.getSetting(ConfigurationSettingNames.Token.REFRESH_TOKEN_TIME_TO_LIVE);
    }

    public SignatureAlgorithm getIdTokenSignatureAlgorithm() {
        return (SignatureAlgorithm)this.getSetting(ConfigurationSettingNames.Token.ID_TOKEN_SIGNATURE_ALGORITHM);
    }

    public boolean isX509CertificateBoundAccessTokens() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.Token.X509_CERTIFICATE_BOUND_ACCESS_TOKENS);
    }

    public static Builder builder() {
        return new Builder().authorizationCodeTimeToLive(Duration.ofMinutes(5L)).accessTokenTimeToLive(Duration.ofMinutes(5L)).accessTokenFormat(OAuth2TokenFormat.SELF_CONTAINED).deviceCodeTimeToLive(Duration.ofMinutes(5L)).reuseRefreshTokens(true).refreshTokenTimeToLive(Duration.ofMinutes(60L)).idTokenSignatureAlgorithm(SignatureAlgorithm.RS256).x509CertificateBoundAccessTokens(false);
    }

    public static Builder withSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        return (Builder)new Builder().settings(s -> s.putAll(settings));
    }

    public static final class Builder
    extends AbstractSettings.AbstractBuilder<TokenSettings, Builder> {
        private Builder() {
        }

        public Builder authorizationCodeTimeToLive(Duration authorizationCodeTimeToLive) {
            Assert.notNull((Object)authorizationCodeTimeToLive, (String)"authorizationCodeTimeToLive cannot be null");
            Assert.isTrue((authorizationCodeTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"authorizationCodeTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.AUTHORIZATION_CODE_TIME_TO_LIVE, authorizationCodeTimeToLive);
        }

        public Builder accessTokenTimeToLive(Duration accessTokenTimeToLive) {
            Assert.notNull((Object)accessTokenTimeToLive, (String)"accessTokenTimeToLive cannot be null");
            Assert.isTrue((accessTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"accessTokenTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.ACCESS_TOKEN_TIME_TO_LIVE, accessTokenTimeToLive);
        }

        public Builder accessTokenFormat(OAuth2TokenFormat accessTokenFormat) {
            Assert.notNull((Object)accessTokenFormat, (String)"accessTokenFormat cannot be null");
            return (Builder)this.setting(ConfigurationSettingNames.Token.ACCESS_TOKEN_FORMAT, accessTokenFormat);
        }

        public Builder deviceCodeTimeToLive(Duration deviceCodeTimeToLive) {
            Assert.notNull((Object)deviceCodeTimeToLive, (String)"deviceCodeTimeToLive cannot be null");
            Assert.isTrue((deviceCodeTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"deviceCodeTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.DEVICE_CODE_TIME_TO_LIVE, deviceCodeTimeToLive);
        }

        public Builder reuseRefreshTokens(boolean reuseRefreshTokens) {
            return (Builder)this.setting(ConfigurationSettingNames.Token.REUSE_REFRESH_TOKENS, reuseRefreshTokens);
        }

        public Builder refreshTokenTimeToLive(Duration refreshTokenTimeToLive) {
            Assert.notNull((Object)refreshTokenTimeToLive, (String)"refreshTokenTimeToLive cannot be null");
            Assert.isTrue((refreshTokenTimeToLive.getSeconds() > 0L ? 1 : 0) != 0, (String)"refreshTokenTimeToLive must be greater than Duration.ZERO");
            return (Builder)this.setting(ConfigurationSettingNames.Token.REFRESH_TOKEN_TIME_TO_LIVE, refreshTokenTimeToLive);
        }

        public Builder idTokenSignatureAlgorithm(SignatureAlgorithm idTokenSignatureAlgorithm) {
            Assert.notNull((Object)idTokenSignatureAlgorithm, (String)"idTokenSignatureAlgorithm cannot be null");
            return (Builder)this.setting(ConfigurationSettingNames.Token.ID_TOKEN_SIGNATURE_ALGORITHM, idTokenSignatureAlgorithm);
        }

        public Builder x509CertificateBoundAccessTokens(boolean x509CertificateBoundAccessTokens) {
            return (Builder)this.setting(ConfigurationSettingNames.Token.X509_CERTIFICATE_BOUND_ACCESS_TOKENS, x509CertificateBoundAccessTokens);
        }

        @Override
        public TokenSettings build() {
            return new TokenSettings(this.getSettings());
        }
    }
}

