/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2TokenExchangeAuthenticationConverter
implements AuthenticationConverter {
    private static final String TOKEN_TYPE_IDENTIFIERS_URI = "https://datatracker.ietf.org/doc/html/rfc8693#section-3";
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";
    private static final Set<String> SUPPORTED_TOKEN_TYPES = Set.of("urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:jwt");

    @Nullable
    public Authentication convert(HttpServletRequest request) {
        String actorTokenType;
        String subjectTokenType;
        String requestedTokenType;
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        String grantType = (String)parameters.getFirst((Object)"grant_type");
        if (!AuthorizationGrantType.TOKEN_EXCHANGE.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        List resources = (List)parameters.getOrDefault((Object)"resource", Collections.emptyList());
        if (!CollectionUtils.isEmpty((Collection)resources)) {
            for (String resource : resources) {
                if (OAuth2TokenExchangeAuthenticationConverter.isValidUri(resource)) continue;
                OAuth2EndpointUtils.throwError("invalid_request", "resource", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
        }
        List audiences = (List)parameters.getOrDefault((Object)"audience", Collections.emptyList());
        String scope = (String)parameters.getFirst((Object)"scope");
        if (StringUtils.hasText((String)scope) && ((List)parameters.get((Object)"scope")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "scope", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        HashSet<String> requestedScopes = null;
        if (StringUtils.hasText((String)scope)) {
            requestedScopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        if (StringUtils.hasText((String)(requestedTokenType = (String)parameters.getFirst((Object)"requested_token_type")))) {
            if (((List)parameters.get((Object)"requested_token_type")).size() != 1) {
                OAuth2EndpointUtils.throwError("invalid_request", "requested_token_type", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
            OAuth2TokenExchangeAuthenticationConverter.validateTokenType("requested_token_type", requestedTokenType);
        } else {
            requestedTokenType = ACCESS_TOKEN_TYPE_VALUE;
        }
        String subjectToken = (String)parameters.getFirst((Object)"subject_token");
        if (!StringUtils.hasText((String)subjectToken) || ((List)parameters.get((Object)"subject_token")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "subject_token", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if (!StringUtils.hasText((String)(subjectTokenType = (String)parameters.getFirst((Object)"subject_token_type"))) || ((List)parameters.get((Object)"subject_token_type")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "subject_token_type", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        } else {
            OAuth2TokenExchangeAuthenticationConverter.validateTokenType("subject_token_type", subjectTokenType);
        }
        String actorToken = (String)parameters.getFirst((Object)"actor_token");
        if (StringUtils.hasText((String)actorToken) && ((List)parameters.get((Object)"actor_token")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "actor_token", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if (StringUtils.hasText((String)(actorTokenType = (String)parameters.getFirst((Object)"actor_token_type")))) {
            if (((List)parameters.get((Object)"actor_token_type")).size() != 1) {
                OAuth2EndpointUtils.throwError("invalid_request", "actor_token_type", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
            OAuth2TokenExchangeAuthenticationConverter.validateTokenType("actor_token_type", actorTokenType);
        }
        if (!StringUtils.hasText((String)actorToken) && StringUtils.hasText((String)actorTokenType)) {
            OAuth2EndpointUtils.throwError("invalid_request", "actor_token", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        } else if (StringUtils.hasText((String)actorToken) && !StringUtils.hasText((String)actorTokenType)) {
            OAuth2EndpointUtils.throwError("invalid_request", "actor_token_type", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("grant_type") || key.equals("resource") || key.equals("audience") || key.equals("requested_token_type") || key.equals("subject_token") || key.equals("subject_token_type") || key.equals("actor_token") || key.equals("actor_token_type") || key.equals("scope"))) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        OAuth2EndpointUtils.validateAndAddDPoPParametersIfAvailable(request, additionalParameters);
        return new OAuth2TokenExchangeAuthenticationToken(requestedTokenType, subjectToken, subjectTokenType, clientPrincipal, actorToken, actorTokenType, new LinkedHashSet<String>(resources), new LinkedHashSet<String>(audiences), requestedScopes, additionalParameters);
    }

    private static void validateTokenType(String parameterName, String tokenTypeValue) {
        if (!SUPPORTED_TOKEN_TYPES.contains(tokenTypeValue)) {
            OAuth2Error error = new OAuth2Error("unsupported_token_type", String.format("OAuth 2.0 Token Exchange parameter: %s", parameterName), TOKEN_TYPE_IDENTIFIERS_URI);
            String message = String.format("OAuth 2.0 Token Exchange parameter: %s - The provided value is not supported by this authorization server. Supported values are %s and %s.", parameterName, ACCESS_TOKEN_TYPE_VALUE, JWT_TOKEN_TYPE_VALUE);
            throw new OAuth2AuthenticationException(error, message);
        }
    }

    private static boolean isValidUri(String uri) {
        try {
            URI validUri = new URI(uri);
            return validUri.isAbsolute() && validUri.getFragment() == null;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }
}

