/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientMetadataClaimAccessor;
import org.springframework.util.Assert;

public abstract class AbstractOAuth2ClientRegistration
implements OAuth2ClientMetadataClaimAccessor,
Serializable {
    private static final long serialVersionUID = 8042785346181558593L;
    private final Map<String, Object> claims;

    protected AbstractOAuth2ClientRegistration(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    protected static abstract class AbstractBuilder<T extends AbstractOAuth2ClientRegistration, B extends AbstractBuilder<T, B>> {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        protected AbstractBuilder() {
        }

        protected Map<String, Object> getClaims() {
            return this.claims;
        }

        protected final B getThis() {
            return (B)this;
        }

        public B clientId(String clientId) {
            return this.claim("client_id", clientId);
        }

        public B clientIdIssuedAt(Instant clientIdIssuedAt) {
            return this.claim("client_id_issued_at", clientIdIssuedAt);
        }

        public B clientSecret(String clientSecret) {
            return this.claim("client_secret", clientSecret);
        }

        public B clientSecretExpiresAt(Instant clientSecretExpiresAt) {
            return this.claim("client_secret_expires_at", clientSecretExpiresAt);
        }

        public B clientName(String clientName) {
            return this.claim("client_name", clientName);
        }

        public B redirectUri(String redirectUri) {
            this.addClaimToClaimList("redirect_uris", redirectUri);
            return this.getThis();
        }

        public B redirectUris(Consumer<List<String>> redirectUrisConsumer) {
            this.acceptClaimValues("redirect_uris", redirectUrisConsumer);
            return this.getThis();
        }

        public B tokenEndpointAuthenticationMethod(String tokenEndpointAuthenticationMethod) {
            return this.claim("token_endpoint_auth_method", tokenEndpointAuthenticationMethod);
        }

        public B grantType(String grantType) {
            this.addClaimToClaimList("grant_types", grantType);
            return this.getThis();
        }

        public B grantTypes(Consumer<List<String>> grantTypesConsumer) {
            this.acceptClaimValues("grant_types", grantTypesConsumer);
            return this.getThis();
        }

        public B responseType(String responseType) {
            this.addClaimToClaimList("response_types", responseType);
            return this.getThis();
        }

        public B responseTypes(Consumer<List<String>> responseTypesConsumer) {
            this.acceptClaimValues("response_types", responseTypesConsumer);
            return this.getThis();
        }

        public B scope(String scope) {
            this.addClaimToClaimList("scope", scope);
            return this.getThis();
        }

        public B scopes(Consumer<List<String>> scopesConsumer) {
            this.acceptClaimValues("scope", scopesConsumer);
            return this.getThis();
        }

        public B jwkSetUrl(String jwkSetUrl) {
            return this.claim("jwks_uri", jwkSetUrl);
        }

        public B claim(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.put(name, value);
            return this.getThis();
        }

        public B claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this.getThis();
        }

        public abstract T build();

        protected void validate() {
            if (this.claims.get("client_id_issued_at") != null || this.claims.get("client_secret") != null) {
                Assert.notNull((Object)this.claims.get("client_id"), (String)"client_id cannot be null");
            }
            if (this.claims.get("client_id_issued_at") != null) {
                Assert.isInstanceOf(Instant.class, (Object)this.claims.get("client_id_issued_at"), (String)"client_id_issued_at must be of type Instant");
            }
            if (this.claims.get("client_secret_expires_at") != null) {
                Assert.notNull((Object)this.claims.get("client_secret"), (String)"client_secret cannot be null");
                Assert.isInstanceOf(Instant.class, (Object)this.claims.get("client_secret_expires_at"), (String)"client_secret_expires_at must be of type Instant");
            }
            if (this.claims.get("redirect_uris") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("redirect_uris"), (String)"redirect_uris must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("redirect_uris")), (String)"redirect_uris cannot be empty");
            }
            if (this.claims.get("grant_types") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("grant_types"), (String)"grant_types must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("grant_types")), (String)"grant_types cannot be empty");
            }
            if (this.claims.get("response_types") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("response_types"), (String)"response_types must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("response_types")), (String)"response_types cannot be empty");
            }
            if (this.claims.get("scope") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("scope"), (String)"scope must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("scope")), (String)"scope cannot be empty");
            }
            if (this.claims.get("jwks_uri") != null) {
                AbstractBuilder.validateURL(this.claims.get("jwks_uri"), "jwksUri must be a valid URL");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            ((List)this.claims.get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.claims.get(name);
            valuesConsumer.accept(values);
        }

        private static void validateURL(Object url, String errorMessage) {
            if (URL.class.isAssignableFrom(url.getClass())) {
                return;
            }
            try {
                new URI(url.toString()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
    }
}

