/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class OAuth2AuthorizationConsentAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -2111287271882598208L;
    private final String authorizationUri;
    private final String clientId;
    private final Authentication principal;
    private final String state;
    private final Set<String> scopes;
    private final Map<String, Object> additionalParameters;

    public OAuth2AuthorizationConsentAuthenticationToken(String authorizationUri, String clientId, Authentication principal, String state, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.hasText((String)authorizationUri, (String)"authorizationUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)state, (String)"state cannot be empty");
        this.authorizationUri = authorizationUri;
        this.clientId = clientId;
        this.principal = principal;
        this.state = state;
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
        this.additionalParameters = Collections.unmodifiableMap(additionalParameters != null ? new HashMap<String, Object>(additionalParameters) : Collections.emptyMap());
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getState() {
        return this.state;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }
}

