/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.util.Assert;

public class OAuth2DeviceAuthorizationRequestAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -561059025431630645L;
    private final Authentication clientPrincipal;
    private final String authorizationUri;
    private final Set<String> scopes;
    private final OAuth2DeviceCode deviceCode;
    private final OAuth2UserCode userCode;
    private final Map<String, Object> additionalParameters;

    public OAuth2DeviceAuthorizationRequestAuthenticationToken(Authentication clientPrincipal, String authorizationUri, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        Assert.hasText((String)authorizationUri, (String)"authorizationUri cannot be empty");
        this.clientPrincipal = clientPrincipal;
        this.authorizationUri = authorizationUri;
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
        this.additionalParameters = Collections.unmodifiableMap(additionalParameters != null ? new HashMap<String, Object>(additionalParameters) : Collections.emptyMap());
        this.deviceCode = null;
        this.userCode = null;
    }

    public OAuth2DeviceAuthorizationRequestAuthenticationToken(Authentication clientPrincipal, @Nullable Set<String> scopes, OAuth2DeviceCode deviceCode, OAuth2UserCode userCode) {
        super(Collections.emptyList());
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        Assert.notNull((Object)deviceCode, (String)"deviceCode cannot be null");
        Assert.notNull((Object)userCode, (String)"userCode cannot be null");
        this.clientPrincipal = clientPrincipal;
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.authorizationUri = null;
        this.additionalParameters = Collections.emptyMap();
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.clientPrincipal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public OAuth2DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public OAuth2UserCode getUserCode() {
        return this.userCode;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }
}

