/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientRegistration;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.util.CollectionUtils;

public final class RegisteredClientOAuth2ClientRegistrationConverter
implements Converter<RegisteredClient, OAuth2ClientRegistration> {
    public OAuth2ClientRegistration convert(RegisteredClient registeredClient) {
        ClientSettings clientSettings;
        OAuth2ClientRegistration.Builder builder = (OAuth2ClientRegistration.Builder)((OAuth2ClientRegistration.Builder)((OAuth2ClientRegistration.Builder)OAuth2ClientRegistration.builder().clientId(registeredClient.getClientId())).clientIdIssuedAt(registeredClient.getClientIdIssuedAt())).clientName(registeredClient.getClientName());
        builder.tokenEndpointAuthenticationMethod(registeredClient.getClientAuthenticationMethods().iterator().next().getValue());
        if (registeredClient.getClientSecret() != null) {
            builder.clientSecret(registeredClient.getClientSecret());
        }
        if (registeredClient.getClientSecretExpiresAt() != null) {
            builder.clientSecretExpiresAt(registeredClient.getClientSecretExpiresAt());
        }
        if (!CollectionUtils.isEmpty(registeredClient.getRedirectUris())) {
            builder.redirectUris(redirectUris -> redirectUris.addAll(registeredClient.getRedirectUris()));
        }
        builder.grantTypes(grantTypes -> registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> grantTypes.add(authorizationGrantType.getValue())));
        if (registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            builder.responseType(OAuth2AuthorizationResponseType.CODE.getValue());
        }
        if (!CollectionUtils.isEmpty(registeredClient.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(registeredClient.getScopes()));
        }
        if ((clientSettings = registeredClient.getClientSettings()).getJwkSetUrl() != null) {
            builder.jwkSetUrl(clientSettings.getJwkSetUrl());
        }
        return builder.build();
    }
}

