/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.server.authorization.AbstractOAuth2AuthorizationServerMetadata;
import org.springframework.security.oauth2.server.authorization.oidc.OidcProviderMetadataClaimAccessor;
import org.springframework.util.Assert;

public final class OidcProviderConfiguration
extends AbstractOAuth2AuthorizationServerMetadata
implements OidcProviderMetadataClaimAccessor {
    private static final long serialVersionUID = -2130128410911549024L;

    private OidcProviderConfiguration(Map<String, Object> claims) {
        super(claims);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withClaims(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        return (Builder)new Builder().claims(c -> c.putAll(claims));
    }

    public static final class Builder
    extends AbstractOAuth2AuthorizationServerMetadata.AbstractBuilder<OidcProviderConfiguration, Builder> {
        private Builder() {
        }

        public Builder subjectType(String subjectType) {
            this.addClaimToClaimList("subject_types_supported", subjectType);
            return this;
        }

        public Builder subjectTypes(Consumer<List<String>> subjectTypesConsumer) {
            this.acceptClaimValues("subject_types_supported", subjectTypesConsumer);
            return this;
        }

        public Builder idTokenSigningAlgorithm(String signingAlgorithm) {
            this.addClaimToClaimList("id_token_signing_alg_values_supported", signingAlgorithm);
            return this;
        }

        public Builder idTokenSigningAlgorithms(Consumer<List<String>> signingAlgorithmsConsumer) {
            this.acceptClaimValues("id_token_signing_alg_values_supported", signingAlgorithmsConsumer);
            return this;
        }

        public Builder userInfoEndpoint(String userInfoEndpoint) {
            return (Builder)this.claim("userinfo_endpoint", userInfoEndpoint);
        }

        public Builder endSessionEndpoint(String endSessionEndpoint) {
            return (Builder)this.claim("end_session_endpoint", endSessionEndpoint);
        }

        @Override
        public OidcProviderConfiguration build() {
            this.validate();
            return new OidcProviderConfiguration(this.getClaims());
        }

        @Override
        protected void validate() {
            super.validate();
            Assert.notNull((Object)this.getClaims().get("jwks_uri"), (String)"jwksUri cannot be null");
            Assert.notNull((Object)this.getClaims().get("subject_types_supported"), (String)"subjectTypes cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.getClaims().get("subject_types_supported"), (String)"subjectTypes must be of type List");
            Assert.notEmpty((Collection)((List)this.getClaims().get("subject_types_supported")), (String)"subjectTypes cannot be empty");
            Assert.notNull((Object)this.getClaims().get("id_token_signing_alg_values_supported"), (String)"idTokenSigningAlgorithms cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.getClaims().get("id_token_signing_alg_values_supported"), (String)"idTokenSigningAlgorithms must be of type List");
            Assert.notEmpty((Collection)((List)this.getClaims().get("id_token_signing_alg_values_supported")), (String)"idTokenSigningAlgorithms cannot be empty");
            if (this.getClaims().get("userinfo_endpoint") != null) {
                Builder.validateURL(this.getClaims().get("userinfo_endpoint"), "userInfoEndpoint must be a valid URL");
            }
            if (this.getClaims().get("end_session_endpoint") != null) {
                Builder.validateURL(this.getClaims().get("end_session_endpoint"), "endSessionEndpoint must be a valid URL");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            ((List)this.getClaims().get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.getClaims().get(name);
            valuesConsumer.accept(values);
        }
    }
}

