/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;

public final class ClientRegistration {
    private String registrationId;
    private String clientId;
    private String clientSecret;
    private ClientAuthenticationMethod clientAuthenticationMethod = ClientAuthenticationMethod.BASIC;
    private AuthorizationGrantType authorizationGrantType;
    private String redirectUri;
    private Set<String> scopes = Collections.emptySet();
    private ProviderDetails providerDetails = new ProviderDetails();
    private String clientName;

    private ClientRegistration() {
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public ProviderDetails getProviderDetails() {
        return this.providerDetails;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String toString() {
        return "ClientRegistration{registrationId='" + this.registrationId + '\'' + ", clientId='" + this.clientId + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", clientAuthenticationMethod=" + this.clientAuthenticationMethod + ", authorizationGrantType=" + this.authorizationGrantType + ", redirectUri='" + this.redirectUri + '\'' + ", scopes=" + this.scopes + ", providerDetails=" + this.providerDetails + ", clientName='" + this.clientName + '\'' + '}';
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId);
    }

    public static class Builder {
        private String registrationId;
        private String clientId;
        private String clientSecret;
        private ClientAuthenticationMethod clientAuthenticationMethod = ClientAuthenticationMethod.BASIC;
        private AuthorizationGrantType authorizationGrantType;
        private String redirectUri;
        private Set<String> scopes;
        private String authorizationUri;
        private String tokenUri;
        private String userInfoUri;
        private String userNameAttributeName;
        private String jwkSetUri;
        private String clientName;

        private Builder(String registrationId) {
            this.registrationId = registrationId;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
            this.clientAuthenticationMethod = clientAuthenticationMethod;
            return this;
        }

        public Builder authorizationGrantType(AuthorizationGrantType authorizationGrantType) {
            this.authorizationGrantType = authorizationGrantType;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scope(String ... scope) {
            if (scope != null && scope.length > 0) {
                this.scopes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(scope)));
            }
            return this;
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder tokenUri(String tokenUri) {
            this.tokenUri = tokenUri;
            return this;
        }

        public Builder userInfoUri(String userInfoUri) {
            this.userInfoUri = userInfoUri;
            return this;
        }

        public Builder userNameAttributeName(String userNameAttributeName) {
            this.userNameAttributeName = userNameAttributeName;
            return this;
        }

        public Builder jwkSetUri(String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public ClientRegistration build() {
            Assert.notNull((Object)this.authorizationGrantType, (String)"authorizationGrantType cannot be null");
            if (AuthorizationGrantType.IMPLICIT.equals((Object)this.authorizationGrantType)) {
                this.validateImplicitGrantType();
            } else {
                this.validateAuthorizationCodeGrantType();
            }
            return this.create();
        }

        private ClientRegistration create() {
            ClientRegistration clientRegistration = new ClientRegistration();
            clientRegistration.registrationId = this.registrationId;
            clientRegistration.clientId = this.clientId;
            clientRegistration.clientSecret = this.clientSecret;
            clientRegistration.clientAuthenticationMethod = this.clientAuthenticationMethod;
            clientRegistration.authorizationGrantType = this.authorizationGrantType;
            clientRegistration.redirectUri = this.redirectUri;
            clientRegistration.scopes = this.scopes;
            ClientRegistration clientRegistration2 = clientRegistration;
            clientRegistration2.getClass();
            ProviderDetails providerDetails = clientRegistration2.new ProviderDetails();
            providerDetails.authorizationUri = this.authorizationUri;
            providerDetails.tokenUri = this.tokenUri;
            providerDetails.userInfoEndpoint.uri = this.userInfoUri;
            providerDetails.userInfoEndpoint.userNameAttributeName = this.userNameAttributeName;
            providerDetails.jwkSetUri = this.jwkSetUri;
            clientRegistration.providerDetails = providerDetails;
            clientRegistration.clientName = this.clientName;
            return clientRegistration;
        }

        private void validateAuthorizationCodeGrantType() {
            Assert.isTrue((boolean)AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)this.authorizationGrantType), (String)("authorizationGrantType must be " + AuthorizationGrantType.AUTHORIZATION_CODE.getValue()));
            Assert.hasText((String)this.registrationId, (String)"registrationId cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.hasText((String)this.clientSecret, (String)"clientSecret cannot be empty");
            Assert.notNull((Object)this.clientAuthenticationMethod, (String)"clientAuthenticationMethod cannot be null");
            Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            Assert.notEmpty(this.scopes, (String)"scopes cannot be empty");
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            Assert.hasText((String)this.tokenUri, (String)"tokenUri cannot be empty");
            if (this.scopes.contains("openid")) {
                Assert.hasText((String)this.jwkSetUri, (String)"jwkSetUri cannot be empty");
            }
            Assert.hasText((String)this.clientName, (String)"clientName cannot be empty");
        }

        private void validateImplicitGrantType() {
            Assert.isTrue((boolean)AuthorizationGrantType.IMPLICIT.equals((Object)this.authorizationGrantType), (String)("authorizationGrantType must be " + AuthorizationGrantType.IMPLICIT.getValue()));
            Assert.hasText((String)this.registrationId, (String)"registrationId cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            Assert.notEmpty(this.scopes, (String)"scopes cannot be empty");
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            Assert.hasText((String)this.clientName, (String)"clientName cannot be empty");
        }
    }

    public class ProviderDetails {
        private String authorizationUri;
        private String tokenUri;
        private UserInfoEndpoint userInfoEndpoint = new UserInfoEndpoint();
        private String jwkSetUri;

        private ProviderDetails() {
        }

        public String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public String getTokenUri() {
            return this.tokenUri;
        }

        public UserInfoEndpoint getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        public String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public class UserInfoEndpoint {
            private String uri;
            private String userNameAttributeName;

            private UserInfoEndpoint() {
            }

            public String getUri() {
                return this.uri;
            }

            public String getUserNameAttributeName() {
                return this.userNameAttributeName;
            }
        }
    }
}

