/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UnAuthenticatedServerOAuth2AuthorizedClientRepository
implements ServerOAuth2AuthorizedClientRepository {
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private final Map<String, OAuth2AuthorizedClient> clientRegistrationIdToAuthorizedClient = new ConcurrentHashMap<String, OAuth2AuthorizedClient>();

    @Override
    public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, Authentication authentication, ServerWebExchange serverWebExchange) {
        Assert.notNull((Object)clientRegistrationId, (String)"clientRegistrationId cannot be null");
        Assert.isNull((Object)serverWebExchange, (String)"serverWebExchange must be null");
        Assert.isTrue((boolean)this.isUnauthenticated(authentication), (String)("The user " + authentication + " should not be authenticated"));
        return Mono.fromSupplier(() -> this.clientRegistrationIdToAuthorizedClient.get(clientRegistrationId));
    }

    @Override
    public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication authentication, ServerWebExchange serverWebExchange) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.isNull((Object)serverWebExchange, (String)"serverWebExchange must be null");
        Assert.isTrue((boolean)this.isUnauthenticated(authentication), (String)("The user " + authentication + " should not be authenticated"));
        return Mono.fromRunnable(() -> {
            String clientRegistrationId = authorizedClient.getClientRegistration().getRegistrationId();
            this.clientRegistrationIdToAuthorizedClient.put(clientRegistrationId, authorizedClient);
        });
    }

    @Override
    public Mono<Void> removeAuthorizedClient(String clientRegistrationId, Authentication authentication, ServerWebExchange serverWebExchange) {
        Assert.notNull((Object)clientRegistrationId, (String)"clientRegistrationId cannot be null");
        Assert.isNull((Object)serverWebExchange, (String)("serverWebExchange " + serverWebExchange + "must be null"));
        Assert.isTrue((boolean)this.isUnauthenticated(authentication), (String)("The user " + authentication + " should not be authenticated"));
        return Mono.fromRunnable(() -> this.clientRegistrationIdToAuthorizedClient.remove(clientRegistrationId));
    }

    private boolean isUnauthenticated(Authentication authentication) {
        return authentication == null || this.trustResolver.isAnonymous(authentication);
    }
}

