/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.web.logout;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcClientInitiatedLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private String postLogoutRedirectUri;

    public OidcClientInitiatedLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String registrationId;
        ClientRegistration clientRegistration;
        URI endSessionEndpoint;
        String targetUrl = null;
        if (authentication instanceof OAuth2AuthenticationToken && authentication.getPrincipal() instanceof OidcUser && (endSessionEndpoint = this.endSessionEndpoint(clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId = ((OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId()))) != null) {
            String idToken = this.idToken(authentication);
            String postLogoutRedirectUri = this.postLogoutRedirectUri(request, clientRegistration);
            targetUrl = this.endpointUri(endSessionEndpoint, idToken, postLogoutRedirectUri);
        }
        return targetUrl != null ? targetUrl : super.determineTargetUrl(request, response);
    }

    private URI endSessionEndpoint(ClientRegistration clientRegistration) {
        ClientRegistration.ProviderDetails providerDetails;
        Object endSessionEndpoint;
        if (clientRegistration != null && (endSessionEndpoint = (providerDetails = clientRegistration.getProviderDetails()).getConfigurationMetadata().get("end_session_endpoint")) != null) {
            return URI.create(endSessionEndpoint.toString());
        }
        return null;
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    private String postLogoutRedirectUri(HttpServletRequest request, ClientRegistration clientRegistration) {
        if (this.postLogoutRedirectUri == null) {
            return null;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("registrationId", clientRegistration.getRegistrationId());
        return UriComponentsBuilder.fromUriString((String)this.postLogoutRedirectUri).buildAndExpand(uriVariables).toUriString();
    }

    private String endpointUri(URI endSessionEndpoint, String idToken, String postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{idToken});
        if (postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    @Deprecated
    public void setPostLogoutRedirectUri(URI postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri.toASCIIString();
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }
}

