/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.Map;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public final class WebSessionOAuth2ServerAuthorizationRequestRepository
implements ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final String DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME = WebSessionOAuth2ServerAuthorizationRequestRepository.class.getName() + ".AUTHORIZATION_REQUEST";
    private final String sessionAttributeName = DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME;

    @Override
    public Mono<OAuth2AuthorizationRequest> loadAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return this.getSessionAttributes(exchange).filter(sessionAttrs -> sessionAttrs.containsKey(this.sessionAttributeName)).map(this::getAuthorizationRequest).filter(authorizationRequest -> state.equals(authorizationRequest.getState()));
    }

    @Override
    public Mono<Void> saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, ServerWebExchange exchange) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return this.getSessionAttributes(exchange).doOnNext(sessionAttrs -> {
            Assert.hasText((String)authorizationRequest.getState(), (String)"authorizationRequest.state cannot be empty");
            sessionAttrs.put(this.sessionAttributeName, authorizationRequest);
        }).then();
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> removeAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return this.getSessionAttributes(exchange).filter(sessionAttrs -> sessionAttrs.containsKey(this.sessionAttributeName)).flatMap(sessionAttrs -> {
            OAuth2AuthorizationRequest authorizationRequest = (OAuth2AuthorizationRequest)sessionAttrs.get(this.sessionAttributeName);
            if (state.equals(authorizationRequest.getState())) {
                sessionAttrs.remove(this.sessionAttributeName);
                return Mono.just((Object)authorizationRequest);
            }
            return Mono.empty();
        });
    }

    private String getStateParameter(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return (String)exchange.getRequest().getQueryParams().getFirst((Object)"state");
    }

    private Mono<Map<String, Object>> getSessionAttributes(ServerWebExchange exchange) {
        return exchange.getSession().map(WebSession::getAttributes);
    }

    private OAuth2AuthorizationRequest getAuthorizationRequest(Map<String, Object> sessionAttrs) {
        return (OAuth2AuthorizationRequest)sessionAttrs.get(this.sessionAttributeName);
    }
}

