/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.client;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.client.RequestAttributeClientRegistrationIdResolver;
import org.springframework.security.oauth2.client.web.client.SecurityContextHolderPrincipalResolver;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class OAuth2ClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Map<HttpStatusCode, String> OAUTH2_ERROR_CODES = Map.of(HttpStatus.UNAUTHORIZED, "invalid_token", HttpStatus.FORBIDDEN, "insufficient_scope");
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private ClientRegistrationIdResolver clientRegistrationIdResolver = new RequestAttributeClientRegistrationIdResolver();
    private PrincipalResolver principalResolver = new SecurityContextHolderPrincipalResolver();
    private OAuth2AuthorizationFailureHandler authorizationFailureHandler = (clientRegistrationId, principal, attributes) -> {};

    public OAuth2ClientHttpRequestInterceptor(OAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
    }

    public void setAuthorizationFailureHandler(OAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public static OAuth2AuthorizationFailureHandler authorizationFailureHandler(OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        return new RemoveAuthorizedClientOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> {
            HttpServletRequest request = (HttpServletRequest)attributes.get(HttpServletRequest.class.getName());
            HttpServletResponse response = (HttpServletResponse)attributes.get(HttpServletResponse.class.getName());
            authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, request, response);
        });
    }

    public static OAuth2AuthorizationFailureHandler authorizationFailureHandler(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, (String)"authorizedClientService cannot be null");
        return new RemoveAuthorizedClientOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal.getName()));
    }

    public void setClientRegistrationIdResolver(ClientRegistrationIdResolver clientRegistrationIdResolver) {
        Assert.notNull((Object)clientRegistrationIdResolver, (String)"clientRegistrationIdResolver cannot be null");
        this.clientRegistrationIdResolver = clientRegistrationIdResolver;
    }

    public void setPrincipalResolver(PrincipalResolver principalResolver) {
        Assert.notNull((Object)principalResolver, (String)"principalResolver cannot be null");
        this.principalResolver = principalResolver;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        Authentication principal = this.principalResolver.resolve(request);
        if (principal == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        this.authorizeClient(request, principal);
        try {
            ClientHttpResponse response = execution.execute(request, body);
            this.handleAuthorizationFailure(request, principal, response.getHeaders(), response.getStatusCode());
            return response;
        }
        catch (RestClientResponseException ex) {
            this.handleAuthorizationFailure(request, principal, ex.getResponseHeaders(), ex.getStatusCode());
            throw ex;
        }
        catch (OAuth2AuthorizationException ex) {
            this.handleAuthorizationFailure(ex, principal);
            throw ex;
        }
    }

    private void authorizeClient(HttpRequest request, Authentication principal) {
        String clientRegistrationId = this.clientRegistrationIdResolver.resolve(request);
        if (clientRegistrationId == null) {
            return;
        }
        OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId(clientRegistrationId).principal(principal).build();
        OAuth2AuthorizedClient authorizedClient = this.authorizedClientManager.authorize(authorizeRequest);
        if (authorizedClient != null) {
            request.getHeaders().setBearerAuth(authorizedClient.getAccessToken().getTokenValue());
        }
    }

    private void handleAuthorizationFailure(HttpRequest request, Authentication principal, HttpHeaders headers, HttpStatusCode httpStatus) {
        OAuth2Error error = OAuth2ClientHttpRequestInterceptor.resolveOAuth2ErrorIfPossible(headers, httpStatus);
        if (error == null) {
            return;
        }
        String clientRegistrationId = this.clientRegistrationIdResolver.resolve(request);
        if (clientRegistrationId == null) {
            return;
        }
        ClientAuthorizationException authorizationException = new ClientAuthorizationException(error, clientRegistrationId);
        this.handleAuthorizationFailure(authorizationException, principal);
    }

    private static OAuth2Error resolveOAuth2ErrorIfPossible(HttpHeaders headers, HttpStatusCode httpStatus) {
        Map<String, String> parameters;
        String wwwAuthenticateHeader = headers.getFirst("WWW-Authenticate");
        if (wwwAuthenticateHeader != null && (parameters = OAuth2ClientHttpRequestInterceptor.parseWwwAuthenticateHeader(wwwAuthenticateHeader)).containsKey("error")) {
            return new OAuth2Error(parameters.get("error"), parameters.get("error_description"), parameters.get("error_uri"));
        }
        String errorCode = OAUTH2_ERROR_CODES.get(httpStatus);
        if (errorCode != null) {
            return new OAuth2Error(errorCode, null, "https://tools.ietf.org/html/rfc6750#section-3.1");
        }
        return null;
    }

    private static Map<String, String> parseWwwAuthenticateHeader(String wwwAuthenticateHeader) {
        if (!StringUtils.hasLength((String)wwwAuthenticateHeader) || !StringUtils.startsWithIgnoreCase((String)wwwAuthenticateHeader, (String)"bearer")) {
            return Map.of();
        }
        String headerValue = wwwAuthenticateHeader.substring("bearer".length()).stripLeading();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String kvPair : StringUtils.delimitedListToStringArray((String)headerValue, (String)",")) {
            String[] kv = StringUtils.split((String)kvPair, (String)"=");
            if (kv == null || kv.length <= 1) continue;
            parameters.put(kv[0].trim(), kv[1].trim().replace("\"", ""));
        }
        return parameters;
    }

    private void handleAuthorizationFailure(OAuth2AuthorizationException authorizationException, Authentication principal) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (requestAttributes != null) {
            attributes.put(HttpServletRequest.class.getName(), requestAttributes.getRequest());
            if (requestAttributes.getResponse() != null) {
                attributes.put(HttpServletResponse.class.getName(), requestAttributes.getResponse());
            }
        }
        this.authorizationFailureHandler.onAuthorizationFailure(authorizationException, principal, attributes);
    }

    @FunctionalInterface
    public static interface ClientRegistrationIdResolver {
        @Nullable
        public String resolve(HttpRequest var1);
    }

    @FunctionalInterface
    public static interface PrincipalResolver {
        @Nullable
        public Authentication resolve(HttpRequest var1);
    }
}

