/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class TokenExchangeGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";
    private final OAuth2Token subjectToken;
    private final OAuth2Token actorToken;

    public TokenExchangeGrantRequest(ClientRegistration clientRegistration, OAuth2Token subjectToken, OAuth2Token actorToken) {
        super(AuthorizationGrantType.TOKEN_EXCHANGE, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.TOKEN_EXCHANGE");
        Assert.notNull((Object)subjectToken, (String)"subjectToken cannot be null");
        this.subjectToken = subjectToken;
        this.actorToken = actorToken;
    }

    public OAuth2Token getSubjectToken() {
        return this.subjectToken;
    }

    public OAuth2Token getActorToken() {
        return this.actorToken;
    }

    static MultiValueMap<String, String> defaultParameters(TokenExchangeGrantRequest grantRequest) {
        ClientRegistration clientRegistration = grantRequest.getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.set((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        parameters.set((Object)"requested_token_type", (Object)ACCESS_TOKEN_TYPE_VALUE);
        OAuth2Token subjectToken = grantRequest.getSubjectToken();
        parameters.set((Object)"subject_token", (Object)subjectToken.getTokenValue());
        parameters.set((Object)"subject_token_type", (Object)TokenExchangeGrantRequest.tokenType(subjectToken));
        OAuth2Token actorToken = grantRequest.getActorToken();
        if (actorToken != null) {
            parameters.set((Object)"actor_token", (Object)actorToken.getTokenValue());
            parameters.set((Object)"actor_token_type", (Object)TokenExchangeGrantRequest.tokenType(actorToken));
        }
        return parameters;
    }

    private static String tokenType(OAuth2Token token) {
        return token instanceof Jwt ? JWT_TOKEN_TYPE_VALUE : ACCESS_TOKEN_TYPE_VALUE;
    }
}

