/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.client;

import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.oauth2.client.annotation.ClientRegistrationId;
import org.springframework.security.oauth2.client.web.ClientAttributes;
import org.springframework.web.service.invoker.HttpRequestValues;

public final class ClientRegistrationIdProcessor
implements HttpRequestValues.Processor {
    public static ClientRegistrationIdProcessor DEFAULT_INSTANCE = new ClientRegistrationIdProcessor();

    public void process(Method method, MethodParameter[] parameters, @Nullable Object[] arguments, HttpRequestValues.Builder builder) {
        ClientRegistrationId registeredId = (ClientRegistrationId)AnnotationUtils.findAnnotation((Method)method, ClientRegistrationId.class);
        if (registeredId != null) {
            String registrationId = registeredId.registrationId();
            builder.configureAttributes(ClientAttributes.clientRegistrationId(registrationId));
        }
    }

    private ClientRegistrationIdProcessor() {
    }
}

