/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.Assert;

public final class ClientAttributes {
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = ClientRegistration.class.getName().concat(".CLIENT_REGISTRATION_ID");

    public static String resolveClientRegistrationId(Map<String, Object> attributes) {
        return (String)attributes.get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    private ClientAttributes() {
    }
}

