/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.JwtBearerGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class DefaultOAuth2TokenRequestParametersConverter<T extends AbstractOAuth2AuthorizationGrantRequest>
implements Converter<T, MultiValueMap<String, String>> {
    private final Converter<T, MultiValueMap<String, String>> defaultParametersConverter = DefaultOAuth2TokenRequestParametersConverter.createDefaultParametersConverter();

    public MultiValueMap<String, String> convert(T grantRequest) {
        MultiValueMap defaultParameters;
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"grant_type", (Object)((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getGrantType().getValue());
        if (!ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            parameters.set((Object)"client_id", (Object)clientRegistration.getClientId());
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            parameters.set((Object)"client_secret", (Object)clientRegistration.getClientSecret());
        }
        if ((defaultParameters = (MultiValueMap)this.defaultParametersConverter.convert(grantRequest)) != null) {
            parameters.addAll(defaultParameters);
        }
        return parameters;
    }

    private static <T extends AbstractOAuth2AuthorizationGrantRequest> Converter<T, MultiValueMap<String, String>> createDefaultParametersConverter() {
        return grantRequest -> {
            if (grantRequest instanceof OAuth2AuthorizationCodeGrantRequest) {
                OAuth2AuthorizationCodeGrantRequest authorizationCodeGrantRequest = (OAuth2AuthorizationCodeGrantRequest)grantRequest;
                return OAuth2AuthorizationCodeGrantRequest.defaultParameters(authorizationCodeGrantRequest);
            }
            if (grantRequest instanceof OAuth2ClientCredentialsGrantRequest) {
                OAuth2ClientCredentialsGrantRequest clientCredentialsGrantRequest = (OAuth2ClientCredentialsGrantRequest)grantRequest;
                return OAuth2ClientCredentialsGrantRequest.defaultParameters(clientCredentialsGrantRequest);
            }
            if (grantRequest instanceof OAuth2RefreshTokenGrantRequest) {
                OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest = (OAuth2RefreshTokenGrantRequest)grantRequest;
                return OAuth2RefreshTokenGrantRequest.defaultParameters(refreshTokenGrantRequest);
            }
            if (grantRequest instanceof JwtBearerGrantRequest) {
                JwtBearerGrantRequest jwtBearerGrantRequest = (JwtBearerGrantRequest)grantRequest;
                return JwtBearerGrantRequest.defaultParameters(jwtBearerGrantRequest);
            }
            if (grantRequest instanceof TokenExchangeGrantRequest) {
                TokenExchangeGrantRequest tokenExchangeGrantRequest = (TokenExchangeGrantRequest)grantRequest;
                return TokenExchangeGrantRequest.defaultParameters(tokenExchangeGrantRequest);
            }
            return null;
        };
    }
}

