/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.reactive.function.client;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public final class ServletBearerExchangeFilterFunction
implements ExchangeFilterFunction {
    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.oauth2Token().map(token -> this.bearer(request, (AbstractOAuth2Token)token)).defaultIfEmpty((Object)request).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0));
    }

    private Mono<AbstractOAuth2Token> oauth2Token() {
        return this.currentAuthentication().filter(authentication -> authentication.getCredentials() instanceof AbstractOAuth2Token).map(Authentication::getCredentials).cast(AbstractOAuth2Token.class);
    }

    private Mono<Authentication> currentAuthentication() {
        return Mono.justOrEmpty((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    private ClientRequest bearer(ClientRequest request, AbstractOAuth2Token token) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(token.getTokenValue())).build();
    }
}

