/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.openid.OpenID4JavaConsumer;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIDAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_CLAIMED_IDENTITY_FIELD = "j_username";
    private OpenIDConsumer consumer;
    private String claimedIdentityFieldName = "j_username";
    private Map<String, String> realmMapping = Collections.emptyMap();

    public OpenIDAuthenticationProcessingFilter() {
        super("/j_spring_openid_security_check");
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.consumer == null) {
            this.consumer = new OpenID4JavaConsumer();
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        OpenIDAuthenticationToken token;
        String identity = request.getParameter("openid.identity");
        if (!StringUtils.hasText((String)identity)) {
            String claimedIdentity = this.obtainUsername(request);
            this.setLastUsername(claimedIdentity, request);
            try {
                String returnToUrl = this.buildReturnToUrl(request);
                String realm = this.lookupRealm(returnToUrl);
                String openIdUrl = this.consumer.beginConsumption(request, claimedIdentity, returnToUrl, realm);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("return_to is '" + returnToUrl + "', realm is '" + realm + "'"));
                    this.logger.debug((Object)("Redirecting to " + openIdUrl));
                }
                response.sendRedirect(openIdUrl);
                return null;
            }
            catch (OpenIDConsumerException e) {
                this.logger.debug((Object)("Failed to consume claimedIdentity: " + claimedIdentity), (Throwable)e);
                throw new AuthenticationServiceException("Unable to process claimed identity '" + claimedIdentity + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Supplied OpenID identity is " + identity));
        }
        try {
            token = this.consumer.endConsumption(request);
        }
        catch (OpenIDConsumerException oice) {
            throw new AuthenticationServiceException("Consumer error", (Throwable)oice);
        }
        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)token);
        if (authentication.isAuthenticated()) {
            this.setLastUsername(token.getIdentityUrl(), request);
        }
        return authentication;
    }

    private void setLastUsername(String username, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null || this.getAllowSessionCreation()) {
            request.getSession().setAttribute("SPRING_SECURITY_LAST_USERNAME", (Object)username);
        }
    }

    protected String lookupRealm(String returnToUrl) {
        String mapping = this.realmMapping.get(returnToUrl);
        if (mapping == null) {
            try {
                URL url = new URL(returnToUrl);
                int port = url.getPort() == -1 ? 80 : url.getPort();
                StringBuffer realmBuffer = new StringBuffer(returnToUrl.length()).append(url.getProtocol()).append("://").append(url.getHost()).append(":").append(port).append("/");
                mapping = realmBuffer.toString();
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)("returnToUrl was not a valid URL: [" + returnToUrl + "]"), (Throwable)e);
            }
        }
        return mapping;
    }

    protected String buildReturnToUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    protected String obtainUsername(HttpServletRequest req) {
        return req.getParameter(this.claimedIdentityFieldName);
    }

    public void setRealmMapping(Map<String, String> realmMapping) {
        this.realmMapping = realmMapping;
    }

    public void setClaimedIdentityFieldName(String claimedIdentityFieldName) {
        this.claimedIdentityFieldName = claimedIdentityFieldName;
    }

    public void setConsumer(OpenIDConsumer consumer) {
        this.consumer = consumer;
    }

    public int getOrder() {
        return FilterChainOrder.OPENID_PROCESSING_FILTER;
    }
}

