/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.springframework.security.openid.AxFetchListFactory;
import org.springframework.security.openid.NullAxFetchListFactory;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationStatus;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenID4JavaConsumer
implements OpenIDConsumer {
    private static final String DISCOVERY_INFO_KEY = DiscoveryInformation.class.getName();
    private static final String ATTRIBUTE_LIST_KEY = "SPRING_SECURITY_OPEN_ID_ATTRIBUTES_FETCH_LIST";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConsumerManager consumerManager;
    private final AxFetchListFactory attributesToFetchFactory;

    public OpenID4JavaConsumer() throws ConsumerException {
        this(new ConsumerManager(), new NullAxFetchListFactory());
    }

    public OpenID4JavaConsumer(AxFetchListFactory attributesToFetchFactory) throws ConsumerException {
        this(new ConsumerManager(), attributesToFetchFactory);
    }

    public OpenID4JavaConsumer(ConsumerManager consumerManager, AxFetchListFactory attributesToFetchFactory) throws ConsumerException {
        this.consumerManager = consumerManager;
        this.attributesToFetchFactory = attributesToFetchFactory;
    }

    @Override
    public String beginConsumption(HttpServletRequest req, String identityUrl, String returnToUrl, String realm) throws OpenIDConsumerException {
        AuthRequest authReq;
        List discoveries;
        try {
            discoveries = this.consumerManager.discover(identityUrl);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error during discovery", e);
        }
        DiscoveryInformation information = this.consumerManager.associate(discoveries);
        req.getSession().setAttribute(DISCOVERY_INFO_KEY, (Object)information);
        try {
            authReq = this.consumerManager.authenticate(information, returnToUrl, realm);
            this.logger.debug((Object)("Looking up attribute fetch list for identifier: " + identityUrl));
            List<OpenIDAttribute> attributesToFetch = this.attributesToFetchFactory.createAttributeList(identityUrl);
            if (!attributesToFetch.isEmpty()) {
                req.getSession().setAttribute(ATTRIBUTE_LIST_KEY, attributesToFetch);
                FetchRequest fetchRequest = FetchRequest.createFetchRequest();
                for (OpenIDAttribute attr : attributesToFetch) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding attribute " + attr.getType() + " to fetch request"));
                    }
                    fetchRequest.addAttribute(attr.getName(), attr.getType(), attr.isRequired(), attr.getCount());
                }
                authReq.addExtension((MessageExtension)fetchRequest);
            }
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error processing ConsumerManager authentication", e);
        }
        catch (ConsumerException e) {
            throw new OpenIDConsumerException("Error processing ConsumerManager authentication", e);
        }
        return authReq.getDestinationUrl(true);
    }

    @Override
    public OpenIDAuthenticationToken endConsumption(HttpServletRequest request) throws OpenIDConsumerException {
        VerificationResult verification;
        ParameterList openidResp = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)request.getSession().getAttribute(DISCOVERY_INFO_KEY);
        if (discovered == null) {
            throw new OpenIDConsumerException("DiscoveryInformation is not available. Possible causes are lost session or replay attack");
        }
        List attributesToFetch = (List)request.getSession().getAttribute(ATTRIBUTE_LIST_KEY);
        request.getSession().removeAttribute(DISCOVERY_INFO_KEY);
        request.getSession().removeAttribute(ATTRIBUTE_LIST_KEY);
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (StringUtils.hasLength((String)queryString)) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.consumerManager.verify(receivingURL.toString(), openidResp, discovered);
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (AssociationException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        Identifier verified = verification.getVerifiedId();
        if (verified == null) {
            Identifier id = discovered.getClaimedIdentifier();
            return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.FAILURE, id == null ? "Unknown" : id.getIdentifier(), "Verification status message: [" + verification.getStatusMsg() + "]", Collections.<OpenIDAttribute>emptyList());
        }
        List<OpenIDAttribute> attributes = this.fetchAxAttributes(verification.getAuthResponse(), attributesToFetch);
        return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.SUCCESS, verified.getIdentifier(), "some message", attributes);
    }

    List<OpenIDAttribute> fetchAxAttributes(Message authSuccess, List<OpenIDAttribute> attributesToFetch) throws OpenIDConsumerException {
        if (attributesToFetch == null || !authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
            return Collections.emptyList();
        }
        this.logger.debug((Object)"Extracting attributes retrieved by attribute exchange");
        List<OpenIDAttribute> attributes = Collections.emptyList();
        try {
            MessageExtension ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            if (ext instanceof FetchResponse) {
                FetchResponse fetchResp = (FetchResponse)ext;
                attributes = new ArrayList<OpenIDAttribute>(attributesToFetch.size());
                for (OpenIDAttribute attr : attributesToFetch) {
                    List values = fetchResp.getAttributeValues(attr.getName());
                    if (values.isEmpty()) continue;
                    OpenIDAttribute fetched = new OpenIDAttribute(attr.getName(), attr.getType(), values);
                    fetched.setRequired(attr.isRequired());
                    attributes.add(fetched);
                }
            }
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Attribute retrieval failed", e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieved attributes" + attributes));
        }
        return attributes;
    }
}

