/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Collection;
import java.util.function.Consumer;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.OpenSamlAssertingPartyDetails;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public final class OpenSamlRelyingPartyRegistration
extends RelyingPartyRegistration {
    OpenSamlRelyingPartyRegistration(RelyingPartyRegistration registration) {
        super(registration.getRegistrationId(), registration.getEntityId(), registration.getAssertionConsumerServiceLocation(), registration.getAssertionConsumerServiceBinding(), registration.getSingleLogoutServiceLocation(), registration.getSingleLogoutServiceResponseLocation(), registration.getSingleLogoutServiceBindings(), registration.getAssertingPartyDetails(), registration.getNameIdFormat(), registration.isAuthnRequestsSigned(), registration.getDecryptionX509Credentials(), registration.getSigningX509Credentials());
    }

    @Override
    public Builder mutate() {
        OpenSamlAssertingPartyDetails party = this.getAssertingPartyDetails();
        return ((Builder)((Builder)((Builder)OpenSamlRelyingPartyRegistration.withAssertingPartyEntityDescriptor(party.getEntityDescriptor()).registrationId(this.getRegistrationId()).entityId(this.getEntityId()).signingX509Credentials(c -> c.addAll(this.getSigningX509Credentials()))).decryptionX509Credentials(c -> c.addAll(this.getDecryptionX509Credentials()))).assertionConsumerServiceLocation(this.getAssertionConsumerServiceLocation()).assertionConsumerServiceBinding(this.getAssertionConsumerServiceBinding()).singleLogoutServiceLocation(this.getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(this.getSingleLogoutServiceResponseLocation()).singleLogoutServiceBindings(c -> c.addAll(this.getSingleLogoutServiceBindings()))).nameIdFormat(this.getNameIdFormat()).authnRequestsSigned(this.isAuthnRequestsSigned()).assertingPartyDetails(assertingParty -> ((OpenSamlAssertingPartyDetails.Builder)((OpenSamlAssertingPartyDetails.Builder)((OpenSamlAssertingPartyDetails.Builder)((OpenSamlAssertingPartyDetails.Builder)assertingParty).entityId(party.getEntityId()).wantAuthnRequestsSigned(party.getWantAuthnRequestsSigned()).signingAlgorithms(algorithms -> algorithms.addAll(party.getSigningAlgorithms()))).verificationX509Credentials(c -> c.addAll(party.getVerificationX509Credentials()))).encryptionX509Credentials(c -> c.addAll(party.getEncryptionX509Credentials()))).singleSignOnServiceLocation(party.getSingleSignOnServiceLocation()).singleSignOnServiceBinding(party.getSingleSignOnServiceBinding()).singleLogoutServiceLocation(party.getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(party.getSingleLogoutServiceResponseLocation()).singleLogoutServiceBinding(party.getSingleLogoutServiceBinding()));
    }

    @Override
    public OpenSamlAssertingPartyDetails getAssertingPartyDetails() {
        return (OpenSamlAssertingPartyDetails)super.getAssertingPartyDetails();
    }

    public static Builder withAssertingPartyEntityDescriptor(EntityDescriptor entityDescriptor) {
        return new Builder(entityDescriptor);
    }

    public static final class Builder
    extends RelyingPartyRegistration.Builder {
        private Builder(EntityDescriptor entityDescriptor) {
            super(entityDescriptor.getEntityID(), OpenSamlAssertingPartyDetails.withEntityDescriptor(entityDescriptor));
        }

        @Override
        public Builder registrationId(String id) {
            return (Builder)super.registrationId(id);
        }

        @Override
        public Builder entityId(String entityId) {
            return (Builder)super.entityId(entityId);
        }

        @Override
        public Builder signingX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            return (Builder)super.signingX509Credentials(credentialsConsumer);
        }

        @Override
        public Builder decryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            return (Builder)super.decryptionX509Credentials(credentialsConsumer);
        }

        @Override
        public Builder assertionConsumerServiceLocation(String assertionConsumerServiceLocation) {
            return (Builder)super.assertionConsumerServiceLocation(assertionConsumerServiceLocation);
        }

        @Override
        public Builder assertionConsumerServiceBinding(Saml2MessageBinding assertionConsumerServiceBinding) {
            return (Builder)super.assertionConsumerServiceBinding(assertionConsumerServiceBinding);
        }

        @Override
        public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
            return this.singleLogoutServiceBindings((T saml2MessageBindings) -> {
                saml2MessageBindings.clear();
                saml2MessageBindings.add(singleLogoutServiceBinding);
            });
        }

        @Override
        public Builder singleLogoutServiceBindings(Consumer<Collection<Saml2MessageBinding>> bindingsConsumer) {
            return (Builder)super.singleLogoutServiceBindings(bindingsConsumer);
        }

        @Override
        public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
            return (Builder)super.singleLogoutServiceLocation(singleLogoutServiceLocation);
        }

        @Override
        public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
            return (Builder)super.singleLogoutServiceResponseLocation(singleLogoutServiceResponseLocation);
        }

        @Override
        public Builder nameIdFormat(String nameIdFormat) {
            return (Builder)super.nameIdFormat(nameIdFormat);
        }

        @Override
        public Builder authnRequestsSigned(Boolean authnRequestsSigned) {
            return (Builder)super.authnRequestsSigned(authnRequestsSigned);
        }

        @Override
        public Builder assertingPartyDetails(Consumer<RelyingPartyRegistration.AssertingPartyDetails.Builder> assertingPartyDetails) {
            return (Builder)super.assertingPartyDetails(assertingPartyDetails);
        }

        @Override
        public OpenSamlRelyingPartyRegistration build() {
            return new OpenSamlRelyingPartyRegistration(super.build());
        }
    }
}

