/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class OpenSamlSigningUtils {
    static String serialize(XMLObject object) {
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(object);
            Element element = marshaller.marshall(object);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    static <O extends SignableXMLObject> O sign(O object, RelyingPartyRegistration relyingPartyRegistration) {
        SignatureSigningParameters parameters = OpenSamlSigningUtils.resolveSigningParameters(relyingPartyRegistration);
        try {
            SignatureSupport.signObject(object, (SignatureSigningParameters)parameters);
            return object;
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    static QueryParametersPartial sign(RelyingPartyRegistration registration) {
        return new QueryParametersPartial(registration);
    }

    private static SignatureSigningParameters resolveSigningParameters(RelyingPartyRegistration relyingPartyRegistration) {
        List<Credential> credentials = OpenSamlSigningUtils.resolveSigningCredentials(relyingPartyRegistration);
        List<String> algorithms = relyingPartyRegistration.getAssertingPartyDetails().getSigningAlgorithms();
        List<String> digests = Collections.singletonList("http://www.w3.org/2001/04/xmlenc#sha256");
        String canonicalization = "http://www.w3.org/2001/10/xml-exc-c14n#";
        SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
        CriteriaSet criteria = new CriteriaSet();
        BasicSignatureSigningConfiguration signingConfiguration = new BasicSignatureSigningConfiguration();
        signingConfiguration.setSigningCredentials(credentials);
        signingConfiguration.setSignatureAlgorithms(algorithms);
        signingConfiguration.setSignatureReferenceDigestMethods(digests);
        signingConfiguration.setSignatureCanonicalizationAlgorithm(canonicalization);
        signingConfiguration.setKeyInfoGeneratorManager(OpenSamlSigningUtils.buildSignatureKeyInfoGeneratorManager());
        criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{signingConfiguration}));
        try {
            SignatureSigningParameters parameters = (SignatureSigningParameters)resolver.resolveSingle((Object)criteria);
            Assert.notNull((Object)parameters, (String)"Failed to resolve any signing credential");
            return parameters;
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private static NamedKeyInfoGeneratorManager buildSignatureKeyInfoGeneratorManager() {
        NamedKeyInfoGeneratorManager namedManager = new NamedKeyInfoGeneratorManager();
        namedManager.setUseDefaultManager(true);
        KeyInfoGeneratorManager defaultManager = namedManager.getDefaultManager();
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        x509Factory.setEmitEntityCertificate(true);
        x509Factory.setEmitEntityCertificateChain(true);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)x509Factory);
        return namedManager;
    }

    private static List<Credential> resolveSigningCredentials(RelyingPartyRegistration relyingPartyRegistration) {
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        for (Saml2X509Credential x509Credential : relyingPartyRegistration.getSigningX509Credentials()) {
            X509Certificate certificate = x509Credential.getCertificate();
            PrivateKey privateKey = x509Credential.getPrivateKey();
            BasicX509Credential credential = CredentialSupport.getSimpleCredential((X509Certificate)certificate, (PrivateKey)privateKey);
            credential.setEntityId(relyingPartyRegistration.getEntityId());
            credential.setUsageType(UsageType.SIGNING);
            credentials.add((Credential)credential);
        }
        return credentials;
    }

    private OpenSamlSigningUtils() {
    }

    static class QueryParametersPartial {
        final RelyingPartyRegistration registration;
        final Map<String, String> components = new LinkedHashMap<String, String>();

        QueryParametersPartial(RelyingPartyRegistration registration) {
            this.registration = registration;
        }

        QueryParametersPartial param(String key, String value) {
            this.components.put(key, value);
            return this;
        }

        Map<String, String> parameters() {
            SignatureSigningParameters parameters = OpenSamlSigningUtils.resolveSigningParameters(this.registration);
            Credential credential = parameters.getSigningCredential();
            String algorithmUri = parameters.getSignatureAlgorithm();
            this.components.put("SigAlg", algorithmUri);
            UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
            for (Map.Entry<String, String> component : this.components.entrySet()) {
                builder.queryParam(component.getKey(), new Object[]{UriUtils.encode((String)component.getValue(), (Charset)StandardCharsets.ISO_8859_1)});
            }
            String queryString = builder.build(true).toString().substring(1);
            try {
                byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)credential, (String)algorithmUri, (byte[])queryString.getBytes(StandardCharsets.UTF_8));
                String b64Signature = Saml2Utils.samlEncode(rawSignature);
                this.components.put("Signature", b64Signature);
            }
            catch (SecurityException ex) {
                throw new Saml2Exception(ex);
            }
            return this.components;
        }
    }
}

