/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Supplier;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.test.context.TestSecurityContextHolderStrategyAdapter;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class WithSecurityContextTestExecutionListener
extends AbstractTestExecutionListener {
    static final String SECURITY_CONTEXT_ATTR_NAME = WithSecurityContextTestExecutionListener.class.getName().concat(".SECURITY_CONTEXT");
    static final SecurityContextHolderStrategy DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY = new TestSecurityContextHolderStrategyAdapter();
    Converter<TestContext, SecurityContextHolderStrategy> securityContextHolderStrategyConverter = testContext -> {
        if (!testContext.hasApplicationContext()) {
            return DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY;
        }
        ApplicationContext context = testContext.getApplicationContext();
        if (context.getBeanNamesForType(SecurityContextHolderStrategy.class).length == 0) {
            return DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY;
        }
        return (SecurityContextHolderStrategy)context.getBean(SecurityContextHolderStrategy.class);
    };

    @NullUnmarked
    public void beforeTestMethod(TestContext testContext) {
        TestSecurityContext testSecurityContext = this.createTestSecurityContext(testContext.getTestMethod(), testContext);
        if (testSecurityContext == null) {
            testSecurityContext = this.createTestSecurityContext(testContext.getTestClass(), testContext);
        }
        if (testSecurityContext == null) {
            return;
        }
        Supplier<SecurityContext> supplier = testSecurityContext.getSecurityContextSupplier();
        if (testSecurityContext.getTestExecutionEvent() == TestExecutionEvent.TEST_METHOD) {
            ((SecurityContextHolderStrategy)this.securityContextHolderStrategyConverter.convert((Object)testContext)).setContext(supplier.get());
        } else {
            testContext.setAttribute(SECURITY_CONTEXT_ATTR_NAME, supplier);
        }
    }

    @NullUnmarked
    public void beforeTestExecution(TestContext testContext) {
        Supplier supplier = (Supplier)testContext.removeAttribute(SECURITY_CONTEXT_ATTR_NAME);
        if (supplier != null) {
            ((SecurityContextHolderStrategy)this.securityContextHolderStrategyConverter.convert((Object)testContext)).setContext((SecurityContext)supplier.get());
        }
    }

    private @Nullable TestSecurityContext createTestSecurityContext(AnnotatedElement annotated, TestContext context) {
        WithSecurityContext withSecurityContext = (WithSecurityContext)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotated, WithSecurityContext.class);
        return this.createTestSecurityContext(annotated, withSecurityContext, context);
    }

    private @Nullable TestSecurityContext createTestSecurityContext(Class<?> annotated, TestContext context) {
        TestContextAnnotationUtils.AnnotationDescriptor withSecurityContextDescriptor = TestContextAnnotationUtils.findAnnotationDescriptor(annotated, WithSecurityContext.class);
        if (withSecurityContextDescriptor == null) {
            return null;
        }
        WithSecurityContext withSecurityContext = (WithSecurityContext)withSecurityContextDescriptor.getAnnotation();
        Class rootDeclaringClass = withSecurityContextDescriptor.getRootDeclaringClass();
        return this.createTestSecurityContext(rootDeclaringClass, withSecurityContext, context);
    }

    @NullUnmarked
    private @Nullable TestSecurityContext createTestSecurityContext(AnnotatedElement annotated, @Nullable WithSecurityContext withSecurityContext, TestContext context) {
        if (withSecurityContext == null) {
            return null;
        }
        withSecurityContext = (WithSecurityContext)AnnotationUtils.synthesizeAnnotation((Annotation)withSecurityContext, (AnnotatedElement)annotated);
        WithSecurityContextFactory<? extends Annotation> factory = this.createFactory(withSecurityContext, context);
        Class type = GenericTypeResolver.resolveTypeArgument(factory.getClass(), WithSecurityContextFactory.class);
        Annotation annotation = this.findAnnotation(annotated, type);
        Supplier<SecurityContext> supplier = () -> {
            try {
                return factory.createSecurityContext(annotation);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unable to create SecurityContext using " + String.valueOf(annotation), ex);
            }
        };
        TestExecutionEvent initialize = withSecurityContext.setupBefore();
        return new TestSecurityContext(supplier, initialize);
    }

    @NullUnmarked
    private @Nullable Annotation findAnnotation(AnnotatedElement annotated, @Nullable Class<? extends Annotation> type) {
        Annotation[] allAnnotations;
        Annotation findAnnotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotated, type);
        if (findAnnotation != null) {
            return findAnnotation;
        }
        for (Annotation annotationToTest : allAnnotations = AnnotationUtils.getAnnotations((AnnotatedElement)annotated)) {
            WithSecurityContext withSecurityContext = (WithSecurityContext)AnnotationUtils.findAnnotation(annotationToTest.annotationType(), WithSecurityContext.class);
            if (withSecurityContext == null) continue;
            return annotationToTest;
        }
        return null;
    }

    private WithSecurityContextFactory<? extends Annotation> createFactory(WithSecurityContext withSecurityContext, TestContext testContext) {
        Class<? extends WithSecurityContextFactory<? extends Annotation>> clazz = withSecurityContext.factory();
        try {
            return (WithSecurityContextFactory)testContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (IllegalStateException ex) {
            return (WithSecurityContextFactory)BeanUtils.instantiateClass(clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @NullUnmarked
    public void afterTestMethod(TestContext testContext) {
        ((SecurityContextHolderStrategy)this.securityContextHolderStrategyConverter.convert((Object)testContext)).clearContext();
    }

    public int getOrder() {
        return 10000;
    }

    static class TestSecurityContext {
        private final Supplier<SecurityContext> securityContextSupplier;
        private final TestExecutionEvent testExecutionEvent;

        TestSecurityContext(Supplier<SecurityContext> securityContextSupplier, TestExecutionEvent testExecutionEvent) {
            this.securityContextSupplier = securityContextSupplier;
            this.testExecutionEvent = testExecutionEvent;
        }

        Supplier<SecurityContext> getSecurityContextSupplier() {
            return this.securityContextSupplier;
        }

        TestExecutionEvent getTestExecutionEvent() {
            return this.testExecutionEvent;
        }
    }
}

