/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HttpSessionSecurityContextRepository
implements SecurityContextRepository {
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class<? extends SecurityContext> securityContextClass = null;
    private Object contextObject = SecurityContextHolder.createEmptyContext();
    private boolean cloneFromHttpSession = false;
    private boolean allowSessionCreation = true;
    private boolean disableUrlRewriting = false;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request = requestResponseHolder.getRequest();
        HttpServletResponse response = requestResponseHolder.getResponse();
        HttpSession httpSession = request.getSession(false);
        SecurityContext context = this.readSecurityContextFromSession(httpSession);
        if (context == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No SecurityContext was available from the HttpSession: " + httpSession + ". " + "A new one will be created."));
            }
            context = this.generateNewContext();
        }
        requestResponseHolder.setResponse((HttpServletResponse)new SaveToSessionResponseWrapper(response, request, httpSession != null, context.hashCode()));
        return context;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        SaveToSessionResponseWrapper responseWrapper = (SaveToSessionResponseWrapper)response;
        if (!responseWrapper.isContextSaved()) {
            responseWrapper.saveContext(context);
        }
    }

    private SecurityContext readSecurityContextFromSession(HttpSession httpSession) {
        boolean debug = this.logger.isDebugEnabled();
        if (httpSession == null) {
            if (debug) {
                this.logger.debug((Object)"No HttpSession currently exists");
            }
            return null;
        }
        Object contextFromSession = httpSession.getAttribute(SPRING_SECURITY_CONTEXT_KEY);
        if (contextFromSession == null) {
            if (debug) {
                this.logger.debug((Object)"HttpSession returned null object for SPRING_SECURITY_CONTEXT");
            }
            return null;
        }
        if (!(contextFromSession instanceof SecurityContext)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("SPRING_SECURITY_CONTEXT did not contain a SecurityContext but contained: '" + contextFromSession + "'; are you improperly modifying the HttpSession directly " + "(you should always use SecurityContextHolder) or using the HttpSession attribute " + "reserved for this class?"));
            }
            return null;
        }
        if (this.cloneFromHttpSession) {
            contextFromSession = this.cloneContext(contextFromSession);
        }
        if (debug) {
            this.logger.debug((Object)("Obtained a valid SecurityContext from SPRING_SECURITY_CONTEXT: '" + contextFromSession + "'"));
        }
        return (SecurityContext)contextFromSession;
    }

    private Object cloneContext(Object context) {
        Object clonedContext = null;
        Assert.isInstanceOf(Cloneable.class, (Object)context, (String)"Context must implement Cloneable and provide a Object.clone() method");
        try {
            Method m = context.getClass().getMethod("clone", new Class[0]);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            clonedContext = m.invoke(context, new Object[0]);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        return clonedContext;
    }

    SecurityContext generateNewContext() {
        SecurityContext context = null;
        if (this.securityContextClass == null) {
            context = SecurityContextHolder.createEmptyContext();
            return context;
        }
        try {
            context = this.securityContextClass.newInstance();
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return context;
    }

    public void setSecurityContextClass(Class contextClass) {
        if (contextClass == null || !SecurityContext.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException("securityContextClass must implement SecurityContext (typically use org.springframework.security.core.context.SecurityContextImpl; existing class is " + contextClass + ")");
        }
        this.securityContextClass = contextClass;
        this.contextObject = this.generateNewContext();
    }

    public void setCloneFromHttpSession(boolean cloneFromHttpSession) {
        this.cloneFromHttpSession = cloneFromHttpSession;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public void setDisableUrlRewriting(boolean disableUrlRewriting) {
        this.disableUrlRewriting = disableUrlRewriting;
    }

    class SaveToSessionResponseWrapper
    extends SaveContextOnUpdateOrErrorResponseWrapper {
        private HttpServletRequest request;
        private boolean httpSessionExistedAtStartOfRequest;
        private int contextHashBeforeChainExecution;

        SaveToSessionResponseWrapper(HttpServletResponse response, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest, int contextHashBeforeChainExecution) {
            super(response, HttpSessionSecurityContextRepository.this.disableUrlRewriting);
            this.request = request;
            this.httpSessionExistedAtStartOfRequest = httpSessionExistedAtStartOfRequest;
            this.contextHashBeforeChainExecution = contextHashBeforeChainExecution;
        }

        void saveContext(SecurityContext context) {
            HttpSession httpSession = this.request.getSession(false);
            if (httpSession == null) {
                httpSession = this.createNewSessionIfAllowed(context);
            }
            if (httpSession != null && context.hashCode() != this.contextHashBeforeChainExecution) {
                if (HttpSessionSecurityContextRepository.this.authenticationTrustResolver.isAnonymous(context.getAuthentication())) {
                    if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                        HttpSessionSecurityContextRepository.this.logger.debug((Object)"SecurityContext contents are anonymous - context will not be stored in HttpSession. ");
                    }
                } else {
                    httpSession.setAttribute(HttpSessionSecurityContextRepository.SPRING_SECURITY_CONTEXT_KEY, (Object)context);
                    if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                        HttpSessionSecurityContextRepository.this.logger.debug((Object)("SecurityContext stored to HttpSession: '" + context + "'"));
                    }
                }
            }
        }

        private HttpSession createNewSessionIfAllowed(SecurityContext context) {
            if (this.httpSessionExistedAtStartOfRequest) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
                return null;
            }
            if (!HttpSessionSecurityContextRepository.this.allowSessionCreation) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)"The HttpSession is currently null, and the HttpSessionContextIntegrationFilter is prohibited from creating an HttpSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                }
                return null;
            }
            if (HttpSessionSecurityContextRepository.this.contextObject.equals(context)) {
                if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                    HttpSessionSecurityContextRepository.this.logger.debug((Object)("HttpSession is null, but SecurityContext has not changed from default: ' " + context + "'; not creating HttpSession or storing SecurityContext"));
                }
                return null;
            }
            if (HttpSessionSecurityContextRepository.this.logger.isDebugEnabled()) {
                HttpSessionSecurityContextRepository.this.logger.debug((Object)"HttpSession being created as SecurityContext is non-default");
            }
            try {
                return this.request.getSession(true);
            }
            catch (IllegalStateException e) {
                HttpSessionSecurityContextRepository.this.logger.warn((Object)"Failed to create a session, as response has been committed. Unable to store SecurityContext.");
                return null;
            }
        }
    }
}

