/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.wrapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.savedrequest.Enumerator;
import org.springframework.security.web.savedrequest.FastHttpDateFormat;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.wrapper.SecurityContextHolderAwareRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedRequestAwareWrapper
extends SecurityContextHolderAwareRequestWrapper {
    protected static final Log logger = LogFactory.getLog(SavedRequestAwareWrapper.class);
    protected static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    protected static Locale defaultLocale = Locale.getDefault();
    protected SavedRequest savedRequest = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[3];

    public SavedRequestAwareWrapper(HttpServletRequest request, PortResolver portResolver, String rolePrefix) {
        super(request, portResolver, rolePrefix);
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Wrapper not replaced; no session available for SavedRequest extraction");
            }
            return;
        }
        SavedRequest saved = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        if (saved != null && saved.doesRequestMatch(request, portResolver)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Wrapper replaced; SavedRequest was: " + saved));
            }
            this.savedRequest = saved;
            session.removeAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
            this.formats[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.formats[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            this.formats[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            this.formats[0].setTimeZone(GMT_ZONE);
            this.formats[1].setTimeZone(GMT_ZONE);
            this.formats[2].setTimeZone(GMT_ZONE);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrapper not replaced; SavedRequest was: " + saved));
        }
    }

    public Cookie[] getCookies() {
        if (this.savedRequest == null) {
            return super.getCookies();
        }
        List<Cookie> cookies = this.savedRequest.getCookies();
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public long getDateHeader(String name) {
        if (this.savedRequest == null) {
            return super.getDateHeader(name);
        }
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        if (this.savedRequest == null) {
            return super.getHeader(name);
        }
        String header = null;
        Iterator<String> iterator = this.savedRequest.getHeaderValues(name);
        if (iterator.hasNext()) {
            header = iterator.next();
        }
        return header;
    }

    public Enumeration getHeaderNames() {
        if (this.savedRequest == null) {
            return super.getHeaderNames();
        }
        return new Enumerator<String>(this.savedRequest.getHeaderNames());
    }

    public Enumeration getHeaders(String name) {
        if (this.savedRequest == null) {
            return super.getHeaders(name);
        }
        return new Enumerator<String>(this.savedRequest.getHeaderValues(name));
    }

    public int getIntHeader(String name) {
        if (this.savedRequest == null) {
            return super.getIntHeader(name);
        }
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public Locale getLocale() {
        if (this.savedRequest == null) {
            return super.getLocale();
        }
        Locale locale = null;
        Iterator<Locale> iterator = this.savedRequest.getLocales();
        if (iterator.hasNext()) {
            locale = iterator.next();
        }
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public Enumeration getLocales() {
        if (this.savedRequest == null) {
            return super.getLocales();
        }
        Iterator<Locale> iterator = this.savedRequest.getLocales();
        if (iterator.hasNext()) {
            return new Enumerator<Locale>(iterator);
        }
        ArrayList<Locale> results = new ArrayList<Locale>(1);
        results.add(defaultLocale);
        return new Enumerator(results.iterator());
    }

    public String getMethod() {
        if (this.savedRequest == null) {
            return super.getMethod();
        }
        return this.savedRequest.getMethod();
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value != null || this.savedRequest == null) {
            return value;
        }
        String[] values = this.savedRequest.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map getParameterMap() {
        if (this.savedRequest == null) {
            return super.getParameterMap();
        }
        Set<String> names = this.getCombinedParameterNames();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(names.size());
        for (String name : names) {
            parameterMap.put(name, this.getParameterValues(name));
        }
        return parameterMap;
    }

    private Set<String> getCombinedParameterNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(super.getParameterMap().keySet());
        if (this.savedRequest != null) {
            names.addAll(this.savedRequest.getParameterMap().keySet());
        }
        return names;
    }

    public Enumeration getParameterNames() {
        return new Enumerator<String>(this.getCombinedParameterNames());
    }

    public String[] getParameterValues(String name) {
        if (this.savedRequest == null) {
            return super.getParameterValues(name);
        }
        String[] savedRequestParams = this.savedRequest.getParameterValues(name);
        String[] wrappedRequestParams = super.getParameterValues(name);
        if (savedRequestParams == null) {
            return wrappedRequestParams;
        }
        if (wrappedRequestParams == null) {
            return savedRequestParams;
        }
        List<String> wrappedParamsList = Arrays.asList(wrappedRequestParams);
        ArrayList<String> combinedParams = new ArrayList<String>(wrappedParamsList);
        for (int i = 0; i < savedRequestParams.length; ++i) {
            if (wrappedParamsList.contains(savedRequestParams[i])) continue;
            combinedParams.add(savedRequestParams[i]);
        }
        return combinedParams.toArray(new String[combinedParams.size()]);
    }
}

