/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.UrlMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final Set<String> HTTP_METHODS = new HashSet<String>(Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Map<Object, List<ConfigAttribute>>> httpMethodMap = new HashMap<String, Map<Object, List<ConfigAttribute>>>();
    private UrlMatcher urlMatcher;
    private boolean stripQueryStringFromUrls;

    public DefaultFilterInvocationSecurityMetadataSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, List<ConfigAttribute>> requestMap) {
        this.urlMatcher = urlMatcher;
        for (Map.Entry<RequestKey, List<ConfigAttribute>> entry : requestMap.entrySet()) {
            this.addSecureUrl(entry.getKey().getUrl(), entry.getKey().getMethod(), entry.getValue());
        }
    }

    private void addSecureUrl(String pattern, String method, List<ConfigAttribute> attr) {
        Map<Object, List<ConfigAttribute>> mapToUse = this.getRequestMapForHttpMethod(method);
        mapToUse.put(this.urlMatcher.compile(pattern), attr);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added URL pattern: " + pattern + "; attributes: " + attr + (method == null ? "" : " for HTTP method '" + method + "'")));
        }
    }

    private Map<Object, List<ConfigAttribute>> getRequestMapForHttpMethod(String method) {
        if (method != null && !HTTP_METHODS.contains(method)) {
            throw new IllegalArgumentException("Unrecognised HTTP method: '" + method + "'");
        }
        Map<Object, List<ConfigAttribute>> methodRequestMap = this.httpMethodMap.get(method);
        if (methodRequestMap == null) {
            methodRequestMap = new LinkedHashMap<Object, List<ConfigAttribute>>();
            this.httpMethodMap.put(method, methodRequestMap);
        }
        return methodRequestMap;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (Map.Entry<String, Map<Object, List<ConfigAttribute>>> entry : this.httpMethodMap.entrySet()) {
            for (List<ConfigAttribute> attrs : entry.getValue().values()) {
                allAttributes.addAll(attrs);
            }
        }
        return allAttributes;
    }

    public List<ConfigAttribute> getAttributes(Object object) {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    public final List<ConfigAttribute> lookupAttributes(String url, String method) {
        Map<Object, List<ConfigAttribute>> requestMap;
        int firstQuestionMarkIndex;
        if (this.stripQueryStringFromUrls && (firstQuestionMarkIndex = url.indexOf("?")) != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.urlMatcher.requiresLowerCaseUrl()) {
            url = url.toLowerCase();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
            }
        }
        if ((requestMap = this.httpMethodMap.get(method)) == null) {
            requestMap = this.httpMethodMap.get(null);
        }
        if (requestMap != null) {
            for (Map.Entry<Object, List<ConfigAttribute>> entry : requestMap.entrySet()) {
                Object p = entry.getKey();
                boolean matched = this.urlMatcher.pathMatchesUrl(entry.getKey(), url);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + p + "; matched=" + matched));
                }
                if (!matched) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    protected UrlMatcher getUrlMatcher() {
        return this.urlMatcher;
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.urlMatcher.requiresLowerCaseUrl();
    }

    public void setStripQueryStringFromUrls(boolean stripQueryStringFromUrls) {
        this.stripQueryStringFromUrls = stripQueryStringFromUrls;
    }
}

