/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.savedrequest.SavedRequestAwareWrapper;

public class HttpSessionRequestCache
implements RequestCache {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;
    private boolean justUseSavedRequestOnGet;

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!this.justUseSavedRequestOnGet || "GET".equals(request.getMethod())) {
            SavedRequest savedRequest = new SavedRequest(request, this.portResolver);
            if (this.createSessionAllowed || request.getSession(false) != null) {
                request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
                this.logger.debug((Object)("SavedRequest added to Session: " + savedRequest));
            }
        }
    }

    public SavedRequest getRequest(HttpServletRequest currentRequest, HttpServletResponse response) {
        HttpSession session = currentRequest.getSession(false);
        if (session != null) {
            return (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        }
        return null;
    }

    public void removeRequest(HttpServletRequest currentRequest, HttpServletResponse response) {
        HttpSession session = currentRequest.getSession(false);
        if (session != null) {
            this.logger.debug((Object)"Removing SavedRequest from session if present");
            session.removeAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        }
    }

    public HttpServletRequest getMatchingRequest(HttpServletRequest request, HttpServletResponse response) {
        SavedRequest saved = this.getRequest(request, response);
        if (saved == null) {
            return null;
        }
        if (!saved.doesRequestMatch(request, this.portResolver)) {
            this.logger.debug((Object)"saved request doesn't match");
            return null;
        }
        return new SavedRequestAwareWrapper(saved, request);
    }

    public void setJustUseSavedRequestOnGet(boolean justUseSavedRequestOnGet) {
        this.justUseSavedRequestOnGet = justUseSavedRequestOnGet;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }
}

