/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.concurrent.SessionRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.session.AuthenticatedSessionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticatedSessionStrategy
implements AuthenticatedSessionStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionRegistry sessionRegistry;
    private boolean migrateSessionAttributes = true;
    private List<String> retainedAttributes = Arrays.asList("SPRING_SECURITY_SAVED_REQUEST_KEY");
    private boolean alwaysCreateSession;

    @Override
    public void onAuthenticationSuccess(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        if (request.getSession(false) == null) {
            if (this.alwaysCreateSession) {
                request.getSession();
            }
            return;
        }
        HttpSession session = request.getSession();
        String originalSessionId = session.getId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invalidating session with Id '" + originalSessionId + "' " + (this.migrateSessionAttributes ? "and" : "without") + " migrating attributes."));
        }
        HashMap<String, Object> attributesToMigrate = this.createMigratedAttributeMap(session);
        session.invalidate();
        session = request.getSession(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Started new session: " + session.getId()));
        }
        if (originalSessionId.equals(session.getId())) {
            this.logger.warn((Object)"Your servlet container did not change the session ID when a new session was created. You will not be adequately protected against session-fixation attacks");
        }
        if (attributesToMigrate != null) {
            for (Map.Entry<String, Object> entry : attributesToMigrate.entrySet()) {
                session.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (this.sessionRegistry != null) {
            this.sessionRegistry.removeSessionInformation(originalSessionId);
            this.sessionRegistry.registerNewSession(session.getId(), authentication.getPrincipal());
        }
    }

    private HashMap<String, Object> createMigratedAttributeMap(HttpSession session) {
        HashMap<String, Object> attributesToMigrate;
        block3: {
            block2: {
                attributesToMigrate = null;
                if (!this.migrateSessionAttributes) break block2;
                attributesToMigrate = new HashMap<String, Object>();
                Enumeration enumer = session.getAttributeNames();
                while (enumer.hasMoreElements()) {
                    String key = (String)enumer.nextElement();
                    attributesToMigrate.put(key, session.getAttribute(key));
                }
                break block3;
            }
            if (this.retainedAttributes.isEmpty()) break block3;
            attributesToMigrate = new HashMap();
            for (String name : this.retainedAttributes) {
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributesToMigrate.put(name, value);
            }
        }
        return attributesToMigrate;
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void setRetainedAttributes(List<String> retainedAttributes) {
        this.retainedAttributes = retainedAttributes;
    }

    public void setAlwaysCreateSession(boolean alwaysCreateSession) {
        this.alwaysCreateSession = alwaysCreateSession;
    }
}

