/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SaveContextOnUpdateOrErrorResponseWrapper
extends HttpServletResponseWrapper {
    private boolean contextSaved = false;
    private boolean disableUrlRewriting;

    public SaveContextOnUpdateOrErrorResponseWrapper(HttpServletResponse response, boolean disableUrlRewriting) {
        super(response);
        this.disableUrlRewriting = disableUrlRewriting;
    }

    protected abstract void saveContext(SecurityContext var1);

    public final void sendError(int sc) throws IOException {
        this.doSaveContext();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.doSaveContext();
        super.sendError(sc, msg);
    }

    public final void sendRedirect(String location) throws IOException {
        this.doSaveContext();
        super.sendRedirect(location);
    }

    private void doSaveContext() {
        this.saveContext(SecurityContextHolder.getContext());
        this.contextSaved = true;
    }

    public final String encodeRedirectUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectUrl(url);
    }

    public final String encodeRedirectURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectURL(url);
    }

    public final String encodeUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeUrl(url);
    }

    public final String encodeURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeURL(url);
    }

    public final boolean isContextSaved() {
        return this.contextSaved;
    }
}

