/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.FirewalledRequest;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChainProxy
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(FilterChainProxy.class);
    public static final String TOKEN_NONE = "#NONE#";
    private Map<String, List<Filter>> uncompiledFilterChainMap;
    private Map<Object, List<Filter>> filterChainMap;
    private UrlMatcher matcher = new AntUrlPathMatcher();
    private boolean stripQueryStringFromUrls = true;
    private HttpFirewall firewall = new DefaultHttpFirewall();
    private FilterChainValidator filterChainValidator = new NullFilterChainValidator();

    public void afterPropertiesSet() {
        Assert.notNull(this.uncompiledFilterChainMap, (String)"filterChainMap must be set");
        this.filterChainValidator.validate(this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FirewalledRequest fwRequest = this.firewall.getFirewalledRequest((HttpServletRequest)request);
        HttpServletResponse fwResponse = this.firewall.getFirewalledResponse((HttpServletResponse)response);
        String url = UrlUtils.buildRequestUrl((HttpServletRequest)fwRequest);
        List<Filter> filters = this.getFilters(url);
        if (filters == null || filters.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(url + (filters == null ? " has no matching filters" : " has an empty filter list")));
            }
            fwRequest.reset();
            chain.doFilter((ServletRequest)fwRequest, (ServletResponse)fwResponse);
            return;
        }
        VirtualFilterChain vfc = new VirtualFilterChain(url, chain, filters, fwRequest);
        vfc.doFilter((ServletRequest)fwRequest, (ServletResponse)fwResponse);
    }

    public List<Filter> getFilters(String url) {
        int firstQuestionMarkIndex;
        if (this.stripQueryStringFromUrls && (firstQuestionMarkIndex = url.indexOf("?")) != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        for (Map.Entry<Object, List<Filter>> entry : this.filterChainMap.entrySet()) {
            Object path = entry.getKey();
            if (this.matcher.requiresLowerCaseUrl()) {
                url = url.toLowerCase();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
                }
            }
            boolean matched = this.matcher.pathMatchesUrl(path, url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + path + "; matched=" + matched));
            }
            if (!matched) continue;
            return entry.getValue();
        }
        return null;
    }

    protected Collection<Filter> obtainAllDefinedFilters() {
        LinkedHashSet<Filter> allFilters = new LinkedHashSet<Filter>();
        for (List<Filter> filters : this.filterChainMap.values()) {
            allFilters.addAll(filters);
        }
        return allFilters;
    }

    public void setFilterChainMap(Map filterChainMap) {
        this.checkContents(filterChainMap);
        this.uncompiledFilterChainMap = new LinkedHashMap<String, List<Filter>>(filterChainMap);
        this.checkPathOrder();
        this.createCompiledMap();
    }

    private void checkContents(Map filterChainMap) {
        for (Object key : filterChainMap.keySet()) {
            Assert.isInstanceOf(String.class, key, (String)("Path key must be a String but found " + key));
            Object filters = filterChainMap.get(key);
            Assert.isInstanceOf(List.class, filters, (String)"Value must be a filter list");
            for (Object filter : (List)filters) {
                Assert.isInstanceOf(Filter.class, filter, (String)"Objects in filter chain must be of type Filter. ");
            }
        }
    }

    private void checkPathOrder() {
        String[] paths = this.uncompiledFilterChainMap.keySet().toArray(new String[0]);
        String universalMatch = this.matcher.getUniversalMatchPattern();
        for (int i = 0; i < paths.length - 1; ++i) {
            if (!paths[i].equals(universalMatch)) continue;
            throw new IllegalArgumentException("A universal match pattern " + universalMatch + " is defined " + " before other patterns in the filter chain, causing them to be ignored. Please check the " + "ordering in your <security:http> namespace or FilterChainProxy bean configuration");
        }
    }

    private void createCompiledMap() {
        this.filterChainMap = new LinkedHashMap<Object, List<Filter>>(this.uncompiledFilterChainMap.size());
        for (String path : this.uncompiledFilterChainMap.keySet()) {
            this.filterChainMap.put(this.matcher.compile(path), this.uncompiledFilterChainMap.get(path));
        }
    }

    public Map<String, List<Filter>> getFilterChainMap() {
        return new LinkedHashMap<String, List<Filter>>(this.uncompiledFilterChainMap);
    }

    public void setMatcher(UrlMatcher matcher) {
        this.matcher = matcher;
    }

    public UrlMatcher getMatcher() {
        return this.matcher;
    }

    public void setFirewall(HttpFirewall firewall) {
        this.firewall = firewall;
    }

    public void setStripQueryStringFromUrls(boolean stripQueryStringFromUrls) {
        this.stripQueryStringFromUrls = stripQueryStringFromUrls;
    }

    public void setFilterChainValidator(FilterChainValidator filterChainValidator) {
        this.filterChainValidator = filterChainValidator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FilterChainProxy[");
        sb.append(" UrlMatcher = ").append(this.matcher);
        sb.append("; Filter Chains: ");
        sb.append(this.uncompiledFilterChainMap);
        sb.append("]");
        return sb.toString();
    }

    private class NullFilterChainValidator
    implements FilterChainValidator {
        private NullFilterChainValidator() {
        }

        public void validate(FilterChainProxy filterChainProxy) {
        }
    }

    public static interface FilterChainValidator {
        public void validate(FilterChainProxy var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VirtualFilterChain
    implements FilterChain {
        private final FilterChain originalChain;
        private final List<Filter> additionalFilters;
        private final FirewalledRequest firewalledRequest;
        private final String url;
        private int currentPosition = 0;

        private VirtualFilterChain(String url, FilterChain chain, List<Filter> additionalFilters, FirewalledRequest firewalledRequest) {
            this.originalChain = chain;
            this.url = url;
            this.additionalFilters = additionalFilters;
            this.firewalledRequest = firewalledRequest;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.additionalFilters.size()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.url + " reached end of additional filter chain; proceeding with original chain"));
                }
                this.firewalledRequest.reset();
                this.originalChain.doFilter(request, response);
            } else {
                ++this.currentPosition;
                Filter nextFilter = this.additionalFilters.get(this.currentPosition - 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.url + " at position " + this.currentPosition + " of " + this.additionalFilters.size() + " in additional filter chain; firing Filter: '" + nextFilter.getClass().getSimpleName() + "'"));
                }
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

