/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.AnyRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChainProxy
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(FilterChainProxy.class);
    private Map<RequestMatcher, List<Filter>> filterChainMap;
    private FilterChainValidator filterChainValidator = new NullFilterChainValidator();

    public void afterPropertiesSet() {
        Assert.notNull(this.filterChainMap, (String)"filterChainMap must be set");
        this.filterChainValidator.validate(this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        List<Filter> filters = this.getFilters(fi.getRequest());
        if (filters == null || filters.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.getRequestUrl() + (filters == null ? " has no matching filters" : " has an empty filter list")));
            }
            chain.doFilter(request, response);
            return;
        }
        VirtualFilterChain virtualFilterChain = new VirtualFilterChain(fi, filters);
        virtualFilterChain.doFilter((ServletRequest)fi.getRequest(), (ServletResponse)fi.getResponse());
    }

    private List<Filter> getFilters(HttpServletRequest request) {
        for (Map.Entry<RequestMatcher, List<Filter>> entry : this.filterChainMap.entrySet()) {
            RequestMatcher matcher = entry.getKey();
            if (!matcher.matches(request)) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<Filter> getFilters(String url) {
        return this.getFilters(new FilterInvocation(url, null).getRequest());
    }

    public void setFilterChainMap(Map filterChainMap) {
        this.checkContents(filterChainMap);
        this.filterChainMap = new LinkedHashMap<RequestMatcher, List<Filter>>(filterChainMap);
        this.checkPathOrder();
    }

    private void checkContents(Map filterChainMap) {
        for (Object key : filterChainMap.keySet()) {
            Assert.isInstanceOf(RequestMatcher.class, key, (String)("Path key must be a RequestMatcher but found " + key));
            Object filters = filterChainMap.get(key);
            Assert.isInstanceOf(List.class, filters, (String)"Value must be a filter list");
            for (Object filter : (List)filters) {
                Assert.isInstanceOf(Filter.class, filter, (String)"Objects in filter chain must be of type Filter. ");
            }
        }
    }

    private void checkPathOrder() {
        Iterator<RequestMatcher> matchers = this.filterChainMap.keySet().iterator();
        while (matchers.hasNext()) {
            if (!(matchers.next() instanceof AnyRequestMatcher) || !matchers.hasNext()) continue;
            throw new IllegalArgumentException("A universal match pattern ('/**') is defined  before other patterns in the filter chain, causing them to be ignored. Please check the ordering in your <security:http> namespace or FilterChainProxy bean configuration");
        }
    }

    public Map<RequestMatcher, List<Filter>> getFilterChainMap() {
        return new LinkedHashMap<RequestMatcher, List<Filter>>(this.filterChainMap);
    }

    public void setFilterChainValidator(FilterChainValidator filterChainValidator) {
        this.filterChainValidator = filterChainValidator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FilterChainProxy[");
        sb.append("Filter Chains: ");
        sb.append(this.filterChainMap);
        sb.append("]");
        return sb.toString();
    }

    private class NullFilterChainValidator
    implements FilterChainValidator {
        private NullFilterChainValidator() {
        }

        public void validate(FilterChainProxy filterChainProxy) {
        }
    }

    public static interface FilterChainValidator {
        public void validate(FilterChainProxy var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VirtualFilterChain
    implements FilterChain {
        private final FilterInvocation fi;
        private final List<Filter> additionalFilters;
        private final int size;
        private int currentPosition = 0;

        private VirtualFilterChain(FilterInvocation filterInvocation, List<Filter> additionalFilters) {
            this.fi = filterInvocation;
            this.additionalFilters = additionalFilters;
            this.size = additionalFilters.size();
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.size) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " reached end of additional filter chain; proceeding with original chain"));
                }
                this.fi.getChain().doFilter(request, response);
            } else {
                ++this.currentPosition;
                Filter nextFilter = this.additionalFilters.get(this.currentPosition - 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " at position " + this.currentPosition + " of " + this.size + " in additional filter chain; firing Filter: '" + nextFilter + "'"));
                }
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

