/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class AntPathRequestMatcher
implements RequestMatcher {
    private static final Log logger = LogFactory.getLog(AntPathRequestMatcher.class);
    private static final AntPathMatcher antMatcher = new AntPathMatcher();
    private final String pattern;
    private final HttpMethod httpMethod;

    public AntPathRequestMatcher(String pattern) {
        this(pattern, null);
    }

    public AntPathRequestMatcher(String pattern, String httpMethod) {
        Assert.hasText((String)pattern, (String)"Pattern cannot be null or empty");
        this.pattern = pattern.toLowerCase();
        this.httpMethod = StringUtils.hasText((String)httpMethod) ? HttpMethod.valueOf((String)httpMethod) : null;
    }

    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && this.httpMethod != HttpMethod.valueOf((String)request.getMethod())) {
            return false;
        }
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + request.getPathInfo();
        }
        url = url.toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking match of request : '" + url + "'; against '" + this.pattern + "'"));
        }
        return antMatcher.match(this.pattern, url);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntPathRequestMatcher)) {
            return false;
        }
        AntPathRequestMatcher other = (AntPathRequestMatcher)obj;
        return this.pattern.equals(other.pattern) && this.httpMethod == other.httpMethod;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ant [pattern='").append(this.pattern).append("'");
        if (this.httpMethod != null) {
            sb.append(", " + this.httpMethod);
        }
        sb.append("]");
        return sb.toString();
    }
}

