/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.ServerHttpBasicAuthenticationConverter;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.HttpBasicServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.WebFilterChainServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthenticationWebFilter
implements WebFilter {
    private final ReactiveAuthenticationManager authenticationManager;
    private ServerAuthenticationSuccessHandler serverAuthenticationSuccessHandler = new WebFilterChainServerAuthenticationSuccessHandler();
    private Function<ServerWebExchange, Mono<Authentication>> authenticationConverter = new ServerHttpBasicAuthenticationConverter();
    private ServerAuthenticationFailureHandler serverAuthenticationFailureHandler = new ServerAuthenticationEntryPointFailureHandler(new HttpBasicServerAuthenticationEntryPoint());
    private ServerSecurityContextRepository serverSecurityContextRepository = NoOpServerSecurityContextRepository.getInstance();
    private ServerWebExchangeMatcher requiresAuthenticationMatcher = ServerWebExchangeMatchers.anyExchange();

    public AuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requiresAuthenticationMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).flatMap(matchResult -> this.authenticationConverter.apply(exchange)).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(token -> this.authenticate(exchange, chain, (Authentication)token));
    }

    private Mono<Void> authenticate(ServerWebExchange exchange, WebFilterChain chain, Authentication token) {
        WebFilterExchange webFilterExchange = new WebFilterExchange(exchange, chain);
        return this.authenticationManager.authenticate(token).flatMap(authentication -> this.onAuthenticationSuccess((Authentication)authentication, webFilterExchange)).onErrorResume(AuthenticationException.class, e -> this.serverAuthenticationFailureHandler.onAuthenticationFailure(webFilterExchange, (AuthenticationException)((Object)e)));
    }

    private Mono<Void> onAuthenticationSuccess(Authentication authentication, WebFilterExchange webFilterExchange) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication(authentication);
        return this.serverSecurityContextRepository.save(exchange, (SecurityContext)securityContext).then(this.serverAuthenticationSuccessHandler.onAuthenticationSuccess(webFilterExchange, authentication));
    }

    public void setServerSecurityContextRepository(ServerSecurityContextRepository serverSecurityContextRepository) {
        Assert.notNull((Object)serverSecurityContextRepository, (String)"securityContextRepository cannot be null");
        this.serverSecurityContextRepository = serverSecurityContextRepository;
    }

    public void setServerAuthenticationSuccessHandler(ServerAuthenticationSuccessHandler serverAuthenticationSuccessHandler) {
        this.serverAuthenticationSuccessHandler = serverAuthenticationSuccessHandler;
    }

    public void setAuthenticationConverter(Function<ServerWebExchange, Mono<Authentication>> authenticationConverter) {
        this.authenticationConverter = authenticationConverter;
    }

    public void setServerAuthenticationFailureHandler(ServerAuthenticationFailureHandler serverAuthenticationFailureHandler) {
        Assert.notNull((Object)serverAuthenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.serverAuthenticationFailureHandler = serverAuthenticationFailureHandler;
    }

    public void setRequiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
        Assert.notNull((Object)requiresAuthenticationMatcher, (String)"requiresAuthenticationMatcher cannot be null");
        this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
    }
}

