/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.net.URI;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectServerAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private final URI location;
    private ServerRedirectStrategy serverRedirectStrategy = new DefaultServerRedirectStrategy();

    public RedirectServerAuthenticationEntryPoint(String location) {
        Assert.notNull((Object)location, (String)"location cannot be null");
        this.location = URI.create(location);
    }

    @Override
    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException e) {
        return this.serverRedirectStrategy.sendRedirect(exchange, this.location);
    }

    public void setServerRedirectStrategy(ServerRedirectStrategy serverRedirectStrategy) {
        Assert.notNull((Object)serverRedirectStrategy, (String)"redirectStrategy cannot be null");
        this.serverRedirectStrategy = serverRedirectStrategy;
    }
}

