/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ServerAuthenticationEntryPointFailureHandler
implements ServerAuthenticationFailureHandler {
    private final ServerAuthenticationEntryPoint serverAuthenticationEntryPoint;

    public ServerAuthenticationEntryPointFailureHandler(ServerAuthenticationEntryPoint serverAuthenticationEntryPoint) {
        Assert.notNull((Object)serverAuthenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
        this.serverAuthenticationEntryPoint = serverAuthenticationEntryPoint;
    }

    @Override
    public Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException exception) {
        return this.serverAuthenticationEntryPoint.commence(webFilterExchange.getExchange(), exception);
    }
}

