/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authorization;

import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.HttpBasicServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.HttpStatusServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ExceptionTranslationWebFilter
implements WebFilter {
    private ServerAuthenticationEntryPoint serverAuthenticationEntryPoint = new HttpBasicServerAuthenticationEntryPoint();
    private ServerAccessDeniedHandler serverAccessDeniedHandler = new HttpStatusServerAccessDeniedHandler(HttpStatus.FORBIDDEN);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).onErrorResume(AccessDeniedException.class, denied -> exchange.getPrincipal().switchIfEmpty(this.commenceAuthentication(exchange, (AccessDeniedException)((Object)denied))).flatMap(principal -> this.serverAccessDeniedHandler.handle(exchange, (AccessDeniedException)((Object)denied))));
    }

    public void setServerAccessDeniedHandler(ServerAccessDeniedHandler serverAccessDeniedHandler) {
        Assert.notNull((Object)serverAccessDeniedHandler, (String)"accessDeniedHandler cannot be null");
        this.serverAccessDeniedHandler = serverAccessDeniedHandler;
    }

    public void setServerAuthenticationEntryPoint(ServerAuthenticationEntryPoint serverAuthenticationEntryPoint) {
        Assert.notNull((Object)serverAuthenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
        this.serverAuthenticationEntryPoint = serverAuthenticationEntryPoint;
    }

    private <T> Mono<T> commenceAuthentication(ServerWebExchange exchange, AccessDeniedException denied) {
        return this.serverAuthenticationEntryPoint.commence(exchange, (AuthenticationException)((Object)new AuthenticationCredentialsNotFoundException("Not Authenticated", (Throwable)denied))).then(Mono.empty());
    }
}

