/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.server.authorization.HttpStatusServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.csrf.CsrfException;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.WebSessionServerCsrfTokenRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CsrfWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher requireCsrfProtectionMatcher = new DefaultRequireCsrfProtectionMatcher();
    private ServerCsrfTokenRepository serverCsrfTokenRepository = new WebSessionServerCsrfTokenRepository();
    private ServerAccessDeniedHandler serverAccessDeniedHandler = new HttpStatusServerAccessDeniedHandler(HttpStatus.FORBIDDEN);
    private String csrfTokenAttributeName = "csrf";

    public void setServerAccessDeniedHandler(ServerAccessDeniedHandler serverAccessDeniedHandler) {
        Assert.notNull((Object)serverAccessDeniedHandler, (String)"serverAccessDeniedHandler");
        this.serverAccessDeniedHandler = serverAccessDeniedHandler;
    }

    public void setCsrfTokenAttributeName(String csrfTokenAttributeName) {
        Assert.notNull((Object)csrfTokenAttributeName, (String)"csrfTokenAttributeName cannot be null");
        this.csrfTokenAttributeName = csrfTokenAttributeName;
    }

    public void setServerCsrfTokenRepository(ServerCsrfTokenRepository serverCsrfTokenRepository) {
        Assert.notNull((Object)serverCsrfTokenRepository, (String)"serverCsrfTokenRepository cannot be null");
        this.serverCsrfTokenRepository = serverCsrfTokenRepository;
    }

    public void setRequireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)requireCsrfProtectionMatcher, (String)"requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requireCsrfProtectionMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).filter(matchResult -> !exchange.getAttributes().containsKey(CsrfToken.class.getName())).flatMap(m -> this.validateToken(exchange)).flatMap(m -> this.continueFilterChain(exchange, chain)).switchIfEmpty(this.continueFilterChain(exchange, chain).then(Mono.empty())).onErrorResume(CsrfException.class, e -> this.serverAccessDeniedHandler.handle(exchange, (AccessDeniedException)((Object)e)));
    }

    private Mono<Void> validateToken(ServerWebExchange exchange) {
        return this.serverCsrfTokenRepository.loadToken(exchange).switchIfEmpty(Mono.error((Throwable)((Object)new CsrfException("CSRF Token has been associated to this client")))).filterWhen(expected -> this.containsValidCsrfToken(exchange, (CsrfToken)expected)).switchIfEmpty(Mono.error((Throwable)((Object)new CsrfException("Invalid CSRF Token")))).then();
    }

    private Mono<Boolean> containsValidCsrfToken(ServerWebExchange exchange, CsrfToken expected) {
        return exchange.getFormData().flatMap(data -> Mono.justOrEmpty((Object)data.getFirst((Object)expected.getParameterName()))).switchIfEmpty(Mono.justOrEmpty((Object)exchange.getRequest().getHeaders().getFirst(expected.getHeaderName()))).map(actual -> actual.equals(expected.getToken()));
    }

    private Mono<Void> continueFilterChain(ServerWebExchange exchange, WebFilterChain chain) {
        return this.csrfToken(exchange).doOnSuccess(csrfToken -> exchange.getAttributes().put(CsrfToken.class.getName(), csrfToken)).doOnSuccess(csrfToken -> exchange.getAttributes().put(this.csrfTokenAttributeName, csrfToken)).flatMap(t -> chain.filter(exchange)).then();
    }

    private Mono<Mono<CsrfToken>> csrfToken(ServerWebExchange exchange) {
        return (Mono)this.serverCsrfTokenRepository.loadToken(exchange).switchIfEmpty(this.serverCsrfTokenRepository.generateToken(exchange)).as(Mono::just);
    }

    private static class DefaultRequireCsrfProtectionMatcher
    implements ServerWebExchangeMatcher {
        private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE, HttpMethod.OPTIONS));

        private DefaultRequireCsrfProtectionMatcher() {
        }

        @Override
        public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
            return Mono.just((Object)exchange.getRequest()).map(r -> r.getMethod()).filter(m -> ALLOWED_METHODS.contains(m)).flatMap(m -> ServerWebExchangeMatcher.MatchResult.notMatch()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.match());
        }
    }
}

