/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.CompositeHeaderWriter;
import org.springframework.security.web.util.OnCommittedResponseWrapper;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class HeaderWriterFilter
extends OncePerRequestFilter {
    private final HeaderWriter headerWriter;
    private boolean shouldWriteHeadersEagerly = false;

    public HeaderWriterFilter(List<HeaderWriter> headerWriters) {
        Assert.notEmpty(headerWriters, (String)"headerWriters cannot be null or empty");
        this.headerWriter = new CompositeHeaderWriter(headerWriters);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.shouldWriteHeadersEagerly) {
            this.doHeadersBefore(request, response, filterChain);
        } else {
            this.doHeadersAfter(request, response, filterChain);
        }
    }

    private void doHeadersBefore(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.headerWriter.writeHeaders(request, response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHeadersAfter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HeaderWriterResponse headerWriterResponse = new HeaderWriterResponse(request, response, this.headerWriter);
        HeaderWriterRequest headerWriterRequest = new HeaderWriterRequest(request, headerWriterResponse);
        try {
            filterChain.doFilter((ServletRequest)headerWriterRequest, (ServletResponse)headerWriterResponse);
        }
        finally {
            headerWriterResponse.writeHeaders();
        }
    }

    public void setShouldWriteHeadersEagerly(boolean shouldWriteHeadersEagerly) {
        this.shouldWriteHeadersEagerly = shouldWriteHeadersEagerly;
    }

    static class HeaderWriterRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher delegate;
        private final HeaderWriterResponse response;

        HeaderWriterRequestDispatcher(RequestDispatcher delegate, HeaderWriterResponse response) {
            this.delegate = delegate;
            this.response = response;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.delegate.forward(request, response);
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.response.onResponseCommitted();
            this.delegate.include(request, response);
        }
    }

    static class HeaderWriterRequest
    extends HttpServletRequestWrapper {
        private final HeaderWriterResponse response;

        HeaderWriterRequest(HttpServletRequest request, HeaderWriterResponse response) {
            super(request);
            this.response = response;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return new HeaderWriterRequestDispatcher(super.getRequestDispatcher(path), this.response);
        }
    }

    static class HeaderWriterResponse
    extends OnCommittedResponseWrapper {
        private final HttpServletRequest request;
        private final HeaderWriter headerWriter;

        HeaderWriterResponse(HttpServletRequest request, HttpServletResponse response, HeaderWriter headerWriter) {
            super(response);
            this.request = request;
            this.headerWriter = headerWriter;
        }

        @Override
        protected void onResponseCommitted() {
            this.writeHeaders();
            this.disableOnResponseCommitted();
        }

        protected void writeHeaders() {
            if (this.isDisableOnResponseCommitted()) {
                return;
            }
            this.headerWriter.writeHeaders(this.request, this.getHttpResponse());
        }

        private HttpServletResponse getHttpResponse() {
            return (HttpServletResponse)this.getResponse();
        }
    }
}

