/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class ClearSiteDataHeaderWriter
implements HeaderWriter {
    private static final String CLEAR_SITE_DATA_HEADER = "Clear-Site-Data";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RequestMatcher requestMatcher;
    private String headerValue;

    public ClearSiteDataHeaderWriter(String ... sources) {
        Assert.notEmpty((Object[])sources, (String)"sources cannot be empty or null");
        this.requestMatcher = new SecureRequestMatcher();
        this.headerValue = Stream.of(sources).map(this::quote).collect(Collectors.joining(", "));
    }

    @Override
    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestMatcher.matches(request)) {
            if (!response.containsHeader(CLEAR_SITE_DATA_HEADER)) {
                response.setHeader(CLEAR_SITE_DATA_HEADER, this.headerValue);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not injecting Clear-Site-Data header since it did not match the requestMatcher " + this.requestMatcher));
        }
    }

    private String quote(String source) {
        return "\"" + source + "\"";
    }

    public String toString() {
        return this.getClass().getName() + " [headerValue=" + this.headerValue + "]";
    }

    private static final class SecureRequestMatcher
    implements RequestMatcher {
        private SecureRequestMatcher() {
        }

        @Override
        public boolean matches(HttpServletRequest request) {
            return request.isSecure();
        }
    }
}

