/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ott;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ott.GenerateOneTimeTokenRequest;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.web.authentication.ott.OneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public final class GenerateOneTimeTokenFilter
extends OncePerRequestFilter {
    private final OneTimeTokenService tokenService;
    private final OneTimeTokenGenerationSuccessHandler tokenGenerationSuccessHandler;
    private RequestMatcher requestMatcher = AntPathRequestMatcher.antMatcher(HttpMethod.POST, "/ott/generate");

    public GenerateOneTimeTokenFilter(OneTimeTokenService tokenService, OneTimeTokenGenerationSuccessHandler tokenGenerationSuccessHandler) {
        Assert.notNull((Object)tokenService, (String)"tokenService cannot be null");
        Assert.notNull((Object)tokenGenerationSuccessHandler, (String)"tokenGenerationSuccessHandler cannot be null");
        this.tokenService = tokenService;
        this.tokenGenerationSuccessHandler = tokenGenerationSuccessHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String username = request.getParameter("username");
        if (!StringUtils.hasText((String)username)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        GenerateOneTimeTokenRequest generateRequest = new GenerateOneTimeTokenRequest(username);
        OneTimeToken ott = this.tokenService.generate(generateRequest);
        this.tokenGenerationSuccessHandler.handle(request, response, ott);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }
}

