/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.registration;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.security.web.webauthn.registration.HtmlTemplates;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class DefaultWebAuthnRegistrationPageGeneratingFilter
extends OncePerRequestFilter {
    private RequestMatcher matcher = AntPathRequestMatcher.antMatcher(HttpMethod.GET, "/webauthn/register");
    private final PublicKeyCredentialUserEntityRepository userEntities;
    private final UserCredentialRepository userCredentials;
    private static final String HTML_TEMPLATE = "<html>\n\t<head>\n\t\t<meta charset=\"utf-8\">\n\t\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n\t\t<meta name=\"description\" content=\"\">\n\t\t<meta name=\"author\" content=\"\">\n\t\t<title>WebAuthn Registration</title>\n\t\t<link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n\t\t<script type=\"text/javascript\" src=\"{{contextPath}}/login/webauthn.js\"></script>\n\t\t<script type=\"text/javascript\">\n\t\t<!--\n\t\t\tconst ui = {\n\t\t\t\tgetRegisterButton: function() {\n\t\t\t\t\treturn document.getElementById('register')\n\t\t\t\t},\n\t\t\t\tgetSuccess: function() {\n\t\t\t\t\treturn document.getElementById('success')\n\t\t\t\t},\n\t\t\t\tgetError: function() {\n\t\t\t\t\treturn document.getElementById('error')\n\t\t\t\t},\n\t\t\t\tgetLabelInput: function() {\n\t\t\t\t\treturn document.getElementById('label')\n\t\t\t\t},\n\t\t\t\tgetDeleteForms: function() {\n\t\t\t\t\treturn Array.from(document.getElementsByClassName(\"delete-form\"))\n\t\t\t\t},\n\t\t\t}\n\t\t\tdocument.addEventListener(\"DOMContentLoaded\",() => setupRegistration({{csrfHeaders}}, \"{{contextPath}}\", ui));\n\t\t//-->\n\t\t</script>\n\t</head>\n\t<body>\n\t\t<div class=\"content\">\n\t\t\t<h2 class=\"center\">WebAuthn Registration</h2>\n\t\t\t<form class=\"default-form\" method=\"post\" action=\"#\" onclick=\"return false\">\n\t\t\t\t<div id=\"success\" class=\"alert alert-success\" role=\"alert\">Success!</div>\n\t\t\t\t<div id=\"error\" class=\"alert alert-danger\" role=\"alert\"></div>\n\t\t\t\t<p>\n\t\t\t\t\t<label for=\"label\" class=\"screenreader\">Passkey Label</label>\n\t\t\t\t\t<input type=\"text\" id=\"label\" name=\"label\" placeholder=\"Passkey Label\" required autofocus>\n\t\t\t\t</p>\n\t\t\t\t<button id=\"register\" class=\"primary\" type=\"submit\">Register</button>\n\t\t\t</form>\n\t\t\t<table class=\"table table-striped\">\n\t\t\t\t<thead>\n\t\t\t\t\t<tr class=\"table-header\">\n\t\t\t\t\t\t<th>Label</th>\n\t\t\t\t\t\t<th>Created</th>\n\t\t\t\t\t\t<th>Last Used</th>\n\t\t\t\t\t\t<th>Signature Count</th>\n\t\t\t\t\t\t<th>Delete</th>\n\t\t\t\t\t</tr>\n\t\t\t\t</thead>\n\t\t\t\t<tbody>\n{{passkeys}}\n\t\t\t\t</tbody>\n\t\t\t</table>\n\t\t</div>\n\t</body>\n</html>\n";
    private static final String PASSKEY_ROW_TEMPLATE = "\t\t\t\t\t<tr class=\"v-middle\">\n\t\t\t\t\t\t<td>{{label}}</td>\n\t\t\t\t\t\t<td>{{created}}</td>\n\t\t\t\t\t\t<td>{{lastUsed}}</td>\n\t\t\t\t\t\t<td class=\"center\">{{signatureCount}}</td>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<form class=\"delete-form no-margin\" method=\"post\" action=\"{{contextPath}}/webauthn/register/{{credentialId}}\">\n\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"method\" value=\"delete\">\n\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"{{csrfParameterName}}\" value=\"{{csrfToken}}\">\n\t\t\t\t\t\t\t\t<button class=\"primary small\" type=\"submit\">Delete</button>\n\t\t\t\t\t\t\t</form>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n";
    private static final String CSRF_HEADERS = "{\"{{headerName}}\" : \"{{headerValue}}\"}";

    public DefaultWebAuthnRegistrationPageGeneratingFilter(PublicKeyCredentialUserEntityRepository userEntities, UserCredentialRepository userCredentials) {
        Assert.notNull((Object)userEntities, (String)"userEntities cannot be null");
        Assert.notNull((Object)userCredentials, (String)"userCredentials cannot be null");
        this.userEntities = userEntities;
        this.userCredentials = userCredentials;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.matcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        CsrfToken csrfToken = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
        response.setContentType("text/html");
        response.setStatus(200);
        String processedTemplate = HtmlTemplates.fromTemplate(HTML_TEMPLATE).withValue("contextPath", request.getContextPath()).withRawHtml("csrfHeaders", this.renderCsrfHeader(csrfToken)).withRawHtml("passkeys", this.passkeyRows(request.getRemoteUser(), request.getContextPath(), csrfToken)).render();
        response.getWriter().write(processedTemplate);
    }

    private String passkeyRows(String username, String contextPath, CsrfToken csrfToken) {
        List credentials;
        PublicKeyCredentialUserEntity userEntity = this.userEntities.findByUsername(username);
        List<Object> list = credentials = userEntity != null ? this.userCredentials.findByUserId(userEntity.getId()) : Collections.emptyList();
        if (credentials.isEmpty()) {
            return "\t\t\t\t\t<tr><td colspan=\"5\">No Passkeys</td></tr>\n";
        }
        return credentials.stream().map(credentialRecord -> this.renderPasskeyRow((CredentialRecord)credentialRecord, contextPath, csrfToken)).collect(Collectors.joining("\n"));
    }

    private String renderPasskeyRow(CredentialRecord credential, String contextPath, CsrfToken csrfToken) {
        return HtmlTemplates.fromTemplate(PASSKEY_ROW_TEMPLATE).withValue("label", credential.getLabel()).withValue("created", DefaultWebAuthnRegistrationPageGeneratingFilter.formatInstant(credential.getCreated())).withValue("lastUsed", DefaultWebAuthnRegistrationPageGeneratingFilter.formatInstant(credential.getLastUsed())).withValue("signatureCount", credential.getSignatureCount()).withValue("credentialId", credential.getCredentialId().toBase64UrlString()).withValue("csrfParameterName", csrfToken.getParameterName()).withValue("csrfToken", csrfToken.getToken()).withValue("contextPath", contextPath).render();
    }

    private static String formatInstant(Instant created) {
        return ZonedDateTime.ofInstant(created, ZoneId.of("UTC")).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_INSTANT);
    }

    private String renderCsrfHeader(CsrfToken csrfToken) {
        return HtmlTemplates.fromTemplate(CSRF_HEADERS).withValue("headerName", csrfToken.getHeaderName()).withValue("headerValue", csrfToken.getToken()).render();
    }
}

