/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.util.Assert;

public class DefaultHttpSecurityExpressionHandler
extends AbstractSecurityExpressionHandler<RequestAuthorizationContext>
implements SecurityExpressionHandler<RequestAuthorizationContext> {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private String defaultRolePrefix = "ROLE_";

    public EvaluationContext createEvaluationContext(Supplier<? extends @Nullable Authentication> authentication, RequestAuthorizationContext context) {
        WebSecurityExpressionRoot root = this.createSecurityExpressionRoot(authentication, context);
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        ctx.setBeanResolver(this.getBeanResolver());
        context.getVariables().forEach((arg_0, arg_1) -> ((StandardEvaluationContext)ctx).setVariable(arg_0, arg_1));
        return ctx;
    }

    protected SecurityExpressionOperations createSecurityExpressionRoot(@Nullable Authentication authentication, RequestAuthorizationContext context) {
        return this.createSecurityExpressionRoot(() -> authentication, context);
    }

    private WebSecurityExpressionRoot createSecurityExpressionRoot(Supplier<? extends @Nullable Authentication> authentication, RequestAuthorizationContext context) {
        WebSecurityExpressionRoot root = new WebSecurityExpressionRoot(authentication, context);
        root.setAuthorizationManagerFactory(this.getAuthorizationManagerFactory());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        if (!DEFAULT_ROLE_PREFIX.equals(this.defaultRolePrefix)) {
            root.setDefaultRolePrefix(this.defaultRolePrefix);
        }
        return root;
    }

    @Deprecated(since="7.0")
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.getDefaultAuthorizationManagerFactory().setTrustResolver(trustResolver);
    }

    @Deprecated(since="7.0")
    public void setDefaultRolePrefix(String defaultRolePrefix) {
        Assert.notNull((Object)defaultRolePrefix, (String)"defaultRolePrefix cannot be null");
        this.getDefaultAuthorizationManagerFactory().setRolePrefix(defaultRolePrefix);
        this.defaultRolePrefix = defaultRolePrefix;
    }
}

