/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.HttpBasicAuthenticationConverter;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.DefaultAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.www.HttpBasicAuthenticationEntryPoint;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthenticationWebFilter
implements WebFilter {
    private final ReactiveAuthenticationManager authenticationManager;
    private AuthenticationSuccessHandler authenticationSuccessHandler = new DefaultAuthenticationSuccessHandler();
    private Function<ServerWebExchange, Mono<Authentication>> authenticationConverter = new HttpBasicAuthenticationConverter();
    private AuthenticationEntryPoint entryPoint = new HttpBasicAuthenticationEntryPoint();

    public AuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.authenticationConverter.apply(exchange).switchIfEmpty(Mono.defer(() -> chain.filter(exchange).cast(Authentication.class))).flatMap(token -> this.authenticationManager.authenticate(token).flatMap(authentication -> this.authenticationSuccessHandler.success((Authentication)authentication, exchange, chain)).onErrorResume(AuthenticationException.class, t -> this.entryPoint.commence(exchange, (AuthenticationException)t)));
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationConverter(Function<ServerWebExchange, Mono<Authentication>> authenticationConverter) {
        this.authenticationConverter = authenticationConverter;
    }

    public void setEntryPoint(AuthenticationEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }
}

