/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import org.springframework.security.web.server.header.HttpHeadersWriter;
import org.springframework.security.web.server.header.StaticHttpHeadersWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class XFrameOptionsHttpHeadersWriter
implements HttpHeadersWriter {
    public static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private HttpHeadersWriter delegate = XFrameOptionsHttpHeadersWriter.createDelegate(Mode.DENY);

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange) {
        return this.delegate.writeHttpHeaders(exchange);
    }

    public void setMode(Mode mode) {
        this.delegate = XFrameOptionsHttpHeadersWriter.createDelegate(mode);
    }

    private static HttpHeadersWriter createDelegate(Mode mode) {
        return StaticHttpHeadersWriter.builder().header(X_FRAME_OPTIONS, mode.name()).build();
    }

    public static enum Mode {
        DENY,
        SAMEORIGIN;

    }
}

