/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.util.matcher;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.ParsingPathMatcher;
import reactor.core.publisher.Mono;

public final class PathMatcherServerWebExchangeMatcher
implements ServerWebExchangeMatcher {
    private static final PathMatcher DEFAULT_PATH_MATCHER = new ParsingPathMatcher();
    private PathMatcher pathMatcher = DEFAULT_PATH_MATCHER;
    private final String pattern;
    private final HttpMethod method;

    public PathMatcherServerWebExchangeMatcher(String pattern) {
        this(pattern, null);
    }

    public PathMatcherServerWebExchangeMatcher(String pattern, HttpMethod method) {
        Assert.notNull((Object)pattern, (String)"pattern cannot be null");
        this.pattern = pattern;
        this.method = method;
    }

    @Override
    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (this.method != null && !this.method.equals((Object)request.getMethod())) {
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }
        String path = request.getPath().pathWithinApplication().value();
        boolean match = this.pathMatcher.match(this.pattern, path);
        if (!match) {
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }
        Map pathVariables = this.pathMatcher.extractUriTemplateVariables(this.pattern, path);
        HashMap<String, Object> variables = new HashMap<String, Object>(pathVariables);
        return ServerWebExchangeMatcher.MatchResult.match(variables);
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
        this.pathMatcher = pathMatcher;
    }

    public String toString() {
        return "PathMatcherServerWebExchangeMatcher{pattern='" + this.pattern + '\'' + ", method=" + this.method + '}';
    }
}

