/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data.provider;

import java.io.DataInput;
import java.io.DataOutput;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.serialization.data.AbstractDataSerializableSessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.provider.DataSerializableSessionAttributesSerializer;
import org.springframework.session.data.gemfire.support.AbstractSession;
import org.springframework.util.StringUtils;

public class DataSerializableSessionSerializer
extends AbstractDataSerializableSessionSerializer<AbstractGemFireOperationsSessionRepository.GemFireSession> {
    public static void register() {
        DataSerializableSessionSerializer.register(DataSerializableSessionSerializer.class);
        DataSerializableSessionAttributesSerializer.register();
    }

    @Override
    public int getId() {
        return 1083616485;
    }

    @Override
    public Class<?>[] getSupportedClasses() {
        return (Class[])ArrayUtils.asArray((Object[])new Class[]{AbstractGemFireOperationsSessionRepository.GemFireSession.class, AbstractGemFireOperationsSessionRepository.DeltaCapableGemFireSession.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(AbstractGemFireOperationsSessionRepository.GemFireSession session, DataOutput out) {
        AbstractGemFireOperationsSessionRepository.GemFireSession gemFireSession = session;
        synchronized (gemFireSession) {
            this.safeWrite(out, output -> output.writeUTF(session.getId()));
            this.safeWrite(out, output -> output.writeLong(session.getCreationTime().toEpochMilli()));
            this.safeWrite(out, output -> output.writeLong(session.getLastAccessedTime().toEpochMilli()));
            this.safeWrite(out, output -> output.writeLong(session.getMaxInactiveInterval().getSeconds()));
            String principalName = session.getPrincipalName();
            int principalNameLength = StringUtils.hasText((String)principalName) ? principalName.length() : 0;
            this.safeWrite(out, output -> output.writeInt(principalNameLength));
            if (principalNameLength > 0) {
                this.safeWrite(out, output -> output.writeUTF(principalName));
            }
            this.safeWrite(out, output -> this.serializeObject(session.getAttributes(), output));
        }
    }

    @Override
    public AbstractGemFireOperationsSessionRepository.GemFireSession deserialize(final DataInput in) {
        AbstractGemFireOperationsSessionRepository.GemFireSession session = AbstractGemFireOperationsSessionRepository.GemFireSession.from(new AbstractSession(){

            @Override
            public String getId() {
                return (String)DataSerializableSessionSerializer.this.safeRead(in, DataInput::readUTF);
            }

            @Override
            public Instant getCreationTime() {
                return (Instant)DataSerializableSessionSerializer.this.safeRead(in, in -> Instant.ofEpochMilli(in.readLong()));
            }

            @Override
            public Instant getLastAccessedTime() {
                return (Instant)DataSerializableSessionSerializer.this.safeRead(in, in -> Instant.ofEpochMilli(in.readLong()));
            }

            @Override
            public Duration getMaxInactiveInterval() {
                return (Duration)DataSerializableSessionSerializer.this.safeRead(in, in -> Duration.ofSeconds(in.readLong()));
            }

            @Override
            public Set<String> getAttributeNames() {
                return Collections.emptySet();
            }
        });
        int principalNameLength = this.safeRead(in, DataInput::readInt);
        if (principalNameLength > 0) {
            session.setPrincipalName(this.safeRead(in, DataInput::readUTF));
        }
        ((AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes)session.getAttributes()).from(this.safeRead(in, this::deserializeObject));
        return session;
    }
}

